/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import java.io.IOException;

public class KeyConstraints {
    public static final long NO_TIMEOUT = 0L;
    public static final long NO_LIMIT = 0xFFFFFFFFL;
    protected static final int SSH_AGENT_CONSTRAINT_TIMEOUT = 50;
    protected static final int SSH_AGENT_CONSTRAINT_USE_LIMIT = 51;
    protected static final int SSH_AGENT_CONSTRAINT_FORWARDING_STEPS = 52;
    protected static final int SSH_AGENT_CONSTRAINT_FORWARDING_PATH = 100;
    protected static final int SSH_AGENT_CONSTRAINT_SSH1_COMPAT = 150;
    protected static final int SSH_AGENT_CONSTRAINT_NEED_USER_VERIFICATION = 151;
    private UnsignedInteger32 timeout = new UnsignedInteger32(0L);
    private UnsignedInteger32 uselimit = new UnsignedInteger32(0xFFFFFFFFL);
    private UnsignedInteger32 maxsteps = new UnsignedInteger32(0xFFFFFFFFL);
    private String forwardingpath = "";
    private boolean userverify = false;
    private boolean compat = false;
    private long keyadded = System.currentTimeMillis();
    private long usedcount = 0L;

    public KeyConstraints() {
    }

    public KeyConstraints(ByteArrayReader byteArrayReader) throws IOException {
        while (byteArrayReader.available() > 0) {
            switch (byteArrayReader.read() & 0xFF) {
                case 50: {
                    this.timeout = byteArrayReader.readUINT32();
                    break;
                }
                case 51: {
                    this.uselimit = byteArrayReader.readUINT32();
                    break;
                }
                case 52: {
                    this.maxsteps = byteArrayReader.readUINT32();
                    break;
                }
                case 100: {
                    this.forwardingpath = byteArrayReader.readString();
                    break;
                }
                case 150: {
                    this.compat = byteArrayReader.read() != 0;
                    break;
                }
                case 151: {
                    boolean bl = this.userverify = byteArrayReader.read() != 0;
                }
            }
        }
    }

    public void setKeyTimeout(UnsignedInteger32 unsignedInteger32) {
        this.timeout = unsignedInteger32;
    }

    public void setKeyUseLimit(int n) {
        this.uselimit = new UnsignedInteger32(n);
    }

    public void setMaximumForwardingSteps(int n) {
        this.maxsteps = new UnsignedInteger32(n);
    }

    public void setForwardingPath(String string) {
        this.forwardingpath = string;
    }

    public void setRequiresUserVerification(boolean bl) {
        this.userverify = bl;
    }

    public void setSSH1Compatible(boolean bl) {
        this.compat = bl;
    }

    public long getKeyTimeout() {
        return this.timeout.longValue();
    }

    public long getKeyUseLimit() {
        return this.uselimit.longValue();
    }

    public long getMaximumForwardingSteps() {
        return this.maxsteps.longValue();
    }

    public long getUsedCount() {
        return this.usedcount;
    }

    public boolean hasTimedOut() {
        return this.timeout.longValue() != 0L ? (System.currentTimeMillis() - this.keyadded) / 1000L > this.timeout.longValue() : false;
    }

    public boolean canUse() {
        return this.uselimit.longValue() != 0L ? this.usedcount < this.uselimit.longValue() : true;
    }

    public void use() {
        ++this.usedcount;
    }

    public String getForwardingPath() {
        return this.forwardingpath;
    }

    public boolean requiresUserVerification() {
        return this.userverify;
    }

    public boolean isSSH1Compatible() {
        return this.compat;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(50);
        byteArrayWriter.writeUINT32(this.timeout);
        byteArrayWriter.write(51);
        byteArrayWriter.writeUINT32(this.uselimit);
        byteArrayWriter.write(52);
        byteArrayWriter.writeUINT32(this.maxsteps);
        byteArrayWriter.write(100);
        byteArrayWriter.writeString(this.forwardingpath);
        byteArrayWriter.write(150);
        byteArrayWriter.write(this.compat ? 0 : 1);
        byteArrayWriter.write(151);
        byteArrayWriter.write(this.userverify ? 0 : 1);
        return byteArrayWriter.toByteArray();
    }
}

