/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.OutputStream;

public class SftpFileOutputStream
extends OutputStream {
    SftpFile file;
    UnsignedInteger64 position = new UnsignedInteger64("0");

    public SftpFileOutputStream(SftpFile sftpFile) throws IOException {
        if (sftpFile.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (sftpFile.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.file = sftpFile;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = (int)this.file.getSFTPSubsystem().maximumPacketSize();
        while (n3 < n2) {
            int n5 = (int)this.file.getSFTPSubsystem().availableWindowSpace() < n4 ? (int)this.file.getSFTPSubsystem().availableWindowSpace() : n4;
            int n6 = n5 < n2 - n3 ? n5 : n2 - n3;
            this.file.getSFTPSubsystem().writeFile(this.file.getHandle(), this.position, byArray, n + n3, n6);
            this.position = UnsignedInteger64.add(this.position, n6);
            n3 += n6;
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.file.getSFTPSubsystem().writeFile(this.file.getHandle(), this.position, byArray, 0, 1);
        this.position = UnsignedInteger64.add(this.position, 1);
    }

    public void close() throws IOException {
        this.file.close();
    }

    protected void finalize() throws IOException {
        if (this.file.getHandle() != null) {
            this.close();
        }
    }
}

