/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash {
    private MessageDigest hash;

    public Hash(String string) throws NoSuchAlgorithmException {
        this.hash = MessageDigest.getInstance(string);
    }

    public void putBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        this.putInt(byArray.length);
        this.hash.update(byArray);
    }

    public void putByte(byte by) {
        this.hash.update(by);
    }

    public void putBytes(byte[] byArray) {
        this.hash.update(byArray);
    }

    public void putInt(int n) {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        try {
            byteArrayWriter.writeInt(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.hash.update(byteArrayWriter.toByteArray());
    }

    public void putString(String string) {
        this.putInt(string.length());
        this.hash.update(string.getBytes());
    }

    public void reset() {
        this.hash.reset();
    }

    public static byte[] simple(byte[] byArray, String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public byte[] doFinal() {
        return this.hash.digest();
    }
}

