/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : JUtils.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.lang.String;
import java.io.File;

class JUtils
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getAppPath
 * DESCRIPTION	  :
 *****************************************************************************/
  String getAppPath(String cs)
  {
    int oldIndex, index;
    File f;
    String s, sep, p, t;

    sep = System.getProperty("path.separator");
    p = System.getProperty("java.class.path");
    p = p.concat(sep);
    oldIndex = 0;
    f = null;

    while(true)
      {
	index = p.indexOf(sep, oldIndex);
	if(index == -1)
	  break;
	if(index > oldIndex)
	  {
	    s = p.substring(oldIndex, index);
	    f = new File(s);
	    if(f.isDirectory())
	      {
		f = new File(s, cs);
		if(f.exists())
		  break;
	      }
	    f = null;
	  }
	oldIndex = index + 1;
      }
    if(f != null)
      {
	s = f.getAbsolutePath();
	sep = System.getProperty("file.separator");
	index = s.lastIndexOf(cs);
	s = s.substring(0,index);
	t = new String(".." + sep);
	while((index = s.indexOf(t)) != -1)
	  {
	    p = s.substring(index+3);
	    if((index = s.lastIndexOf(sep, index-2)) == -1)
	      break;
	    s = s.substring(0,index+1) + p;
	  }
	t = new String("." + sep);
	while((index = s.indexOf(t)) != -1)
	  {
	    p = s.substring(0,index);
	    s = p + s.substring(index+2);
	  }
	return(s);
      }
    return(null);
  }

}  /* END OF CLASS : JUtils */


/* END OF FILE : JUtils.java */

