/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.tournament;

import java.util.ArrayList;
import java.util.List;
import jp.ac.nii.icpc2010.tournament.Logger;
import jp.ac.nii.icpc2010.tournament.Player;
import jp.ac.nii.icpc2010.tournament.TournamentMaster;

public class TournamentRunner {
    public static void main(String[] args) {
        boolean simulate = false;
        int threads = 1;
        assert (args.length > 0);
        ArrayList<Player> players = new ArrayList<Player>();
        int argPos = 0;
        while (argPos < args.length) {
            if (args[argPos].equals("-threads")) {
                threads = Integer.parseInt(args[argPos + 1]);
                ++argPos;
            } else if (args[argPos].equals("-simulate")) {
                simulate = true;
            } else if (args[argPos].equals("-players")) {
                int playerCount = 0;
                while (playerCount < (args.length - argPos - 1) / 2) {
                    int basePos = argPos + 1 + 2 * playerCount;
                    players.add(new Player(args[basePos], args[basePos + 1]));
                    ++playerCount;
                }
                argPos += playerCount * 2;
            } else {
                System.err.println("Unknown argument " + args[argPos]);
            }
            ++argPos;
        }
        TournamentRunner.randomizeOrder(players);
        if (simulate) {
            Logger.log("Simulating");
            TournamentRunner.simulate(threads);
        } else {
            assert (players.size() > 0);
            new TournamentMaster(players, threads);
        }
    }

    private static void randomizeOrder(List<Player> list) {
        int size = list.size();
        int i = 0;
        while (i < size * 10) {
            int pos1 = (int)(Math.random() * (double)size);
            int pos2 = (int)(Math.random() * (double)size);
            Player x = list.get(pos1);
            list.add(pos1, list.get(pos2));
            list.remove(pos1 + 1);
            list.add(pos2, x);
            list.remove(pos2 + 1);
            ++i;
        }
    }

    private static void simulate(int threads) {
        int teams = 48;
        Logger.log("Estimation: " + TournamentRunner.estimatedRunningTime(teams, 4, threads));
        ArrayList<Player> players = new ArrayList<Player>();
        int x = 0;
        while (x++ < teams) {
            players.add(Math.random() < 0.5 ? new Player("r" + x, "HilbertCurveSelecter") : new Player("s" + x, "CPUDrainer"));
        }
        new TournamentMaster(players, threads);
    }

    public static long estimatedRunningTime(int teams, int groupSize, int threads) {
        int groups;
        int curTeams = teams;
        long matches = 0L;
        long groupMatches = TournamentRunner.factorial(groupSize - 1);
        do {
            groups = (int)Math.ceil(curTeams / groupSize);
            matches = (long)((double)matches + Math.ceil((long)groups * groupMatches / (long)threads));
        } while ((curTeams = groups * groupSize / 2) >= groupSize);
        return matches;
    }

    public static long factorial(int n) {
        if (n <= 1) {
            return 1L;
        }
        return (long)n * TournamentRunner.factorial(n - 1);
    }
}

