package jp.ac.nii.icpc2010.manager;

/**
 * Basic configuration settings for the game. May be useful in making strategic decisions. 
 * @author johan
 *
 */
public interface IBasicOptions {

	/**
	 * Obtain the number of turns in a round.
	 * @return
	 */
	public int getMaxTurns();
	
	/**
	 * Obtain the number of rounds in a match.
	 * @return
	 */
	public int getGameRounds();

	/**
	 * Obtain the timeout in milliseconds for an individual turn.
	 * @return
	 */
	public long getRunTimeout();

	
	/**
	 * Obtain the maximum length of the trail. Only meaningful if hasTrailLimit() returns true.
	 * @return Maximum length of the trail
	 */
	public int getTrailLimitAmount();

	/**
	 * Test whether the trail is unlimited or not.
	 * @return false if the trail has unlimited length.
	 */
	public boolean hasTrailLimit();

	

}