package jp.ac.nii.icpc2010.manager;

import java.util.Vector;

public interface IOptionSource extends IBasicOptions {

	public String getLevelName();

	public Vector<String> getPlayerClasses();

	public boolean isLoggingOn();

	public String[] getBackgroundImageName();

	public String getWallImageName();

	public String getCoinImageName();
	
	public TimeoutAction getTimeoutAction();

	public long getTurnTimeslot();

    /**
	 * File to record the game to, or null if none was set
	 * @return
	 */
	public String getRecordFile();

	/**
	 * File to playback the game from, or null if none was set
	 * @return
	 */
	public String getPlaybackFile();

}