package jp.ac.nii.icpc2010.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class QuoteManager {

	Vector<String> quotes = new Vector<String>();
	Random random;
	private static QuoteManager singleton;
	private String winner;
	private String loser;
	private String quote;

	public static QuoteManager Singleton() {
		if (singleton == null)
			singleton = new QuoteManager();

		return singleton;
	}

	public QuoteManager() {
		random = new Random(System.currentTimeMillis()); 
		loadQuotes();
	}

	public String getQuote() {
		
		return "Hey " + loser + "! " + quote;
	}

	private void loadQuotes() {
		File quoteFile = new File("quotes.txt");
		if (quoteFile.exists()) {
			try {
				BufferedReader input =  new BufferedReader(new FileReader(quoteFile));
				try {
					String line = null;
					while (( line = input.readLine()) != null){

						if (line.contains("Quote") || line.equals(""))
							continue;

						quotes.add(line);
					}
				}
				finally {
					input.close();
				}
			}
			catch (IOException ex){
				ex.printStackTrace();
			}
		}
	}
	
	public String getWinner() {
		return winner;
	}
	
	public String getLoser() {
		return loser;
	}

	public void setWinner(String winner) {
		this.winner = winner;
	}

	public void setLoser(String loser) {
		this.loser = loser;
	}

	public void loadNewQuote() {
		if (quotes.size() > 0) {
			quote = quotes.get(random.nextInt(quotes.size()));
		}
	}
}
