package jp.ac.nii.icpc2010.players;

import java.awt.event.KeyEvent;

import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;
import jp.ac.nii.icpc2010.playfield.RefPlayField;



public class HumanPlayer extends BasePlayer
{

	public HumanPlayer(int id, IPlayField playField) {
		super(id, playField);
		// TODO Auto-generated constructor stub
		this.fd = FieldDirection.Up;
	}

	FieldDirection fd;


	public FieldDirection getInput()
	{
		KeyEvent e = ((RefPlayField) getPlayField()).getKeyPressed();
		if(e != null){
			switch(e.getKeyCode())
			{
			case KeyEvent.VK_UP:
				setDir(FieldDirection.Up);
				break;
			case KeyEvent.VK_DOWN:
				setDir(FieldDirection.Down);
				break;
			case KeyEvent.VK_LEFT:
				setDir(FieldDirection.Left);
				break;
			case KeyEvent.VK_RIGHT:
				setDir(FieldDirection.Right);
				break;
			}
		}

		return this.fd;
	}

	private void setDir(FieldDirection fd){
		if(fd != this.fd){
			System.out.println("HumanPlayer: change to " + fd.toString());
			this.fd = fd;
		}
	}
}
