package jp.ac.nii.icpc2010.players;
import java.util.ArrayList;
import java.util.List;

import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

/**
 * Select directions in a specific order, beginning with a most 
 * preferred direction and choosing the next direction if the preferred 
 * direction is not available
 * 
 * based on "Robert Xiao's Tron Strategy Guide"
 * (see http://csclub.uwaterloo.ca/contest/xiao_strategy.php)
 * 
 * @author yukino
 *
 */
public class OrderedPlayer extends BasePlayer
{
	public OrderedPlayer(int id, IPlayField playField) {
		super(id, playField);
		// TODO Auto-generated constructor stub
	}

	FieldDirection prev_dir;

	public FieldDirection getInput()
	{
		int curx = getX();
		int cury = getY();
		
		List<FieldDirection> safeDirs = getSafeDirs(curx, cury);
		
		if (safeDirs.isEmpty())
		{
			//give up
			return prev_dir;
		}
		
		FieldDirection decision = safeDirs.get(0);
		FieldDirection[] order = {FieldDirection.Up, FieldDirection.Right, FieldDirection.Down, FieldDirection.Left};

		for (FieldDirection dir: order) {
			if (safeDirs.contains(dir)) {
				decision = dir;
				break;
			}
		}

		prev_dir = decision;
		return decision;
	}
}