package jp.ac.nii.icpc2010.recorder;

import java.util.ArrayList;
import java.util.List;

import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;

/**
 * Not threadsafe.
 * @author johan
 *
 */
public abstract class AbstractRecorder implements IRecorder {

	private final int _numPlayers;
	private String[] _playerNames;
	
	private List<Double> playerScores = new ArrayList<Double>();
	private List<PlayerEvent[]> _events;		
	private boolean _closed;
	
	protected OptionsManager om;
		
	public AbstractRecorder(String[] playerNames, OptionsManager om) {
		_numPlayers = playerNames.length;
		_playerNames = playerNames;
		_events = new ArrayList<PlayerEvent[]>();
		this.om = om;
	}
	
	public  void addEvents(PlayerEvent[] events) throws TronException {
		if (_closed) {
			throw new TronException("Recorder closed");
		}
		_events.add(events);		
	}
	
	@Override
	public void addPlayerScore(double score) throws TronException {
		if (_closed) {
			throw new TronException("Recorder closed");
		}
		playerScores.add(score);
	}
	
	public void closeWriting() throws TronException {
		_closed = true;
	}
	
	public void load() throws TronException {
		
	}
	
	public List<PlayerEvent[]> getEvents() {
		return _events;
	}
	
	public String[] getPlayerNames() {
		return _playerNames;
	}
	
	void setEvents(List<PlayerEvent[]> events) {
		_events = events;
		if (!om.isTournamentMode())
			System.out.println("Loaded " + _events.size() + " event sets.");
	}
	void setPlayerNames(String[] names) {
	
		_playerNames = names;
	}
	
	@Override
	public List<Double> getPlayerScores() {
		return playerScores;
	}
	public void setPlayerScores(List<Double> playerScores) {
		this.playerScores = playerScores;
	}
	
}
