package jp.ac.nii.icpc2010.recorder;

import java.util.List;

import jp.ac.nii.icpc2010.players.BasePlayer;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.RefPlayField;

/**
 * A player that replays the moves previously recorded by a recorder.
 * @author johan
 *
 */
public class ReplayPlayer extends BasePlayer {

	
	private final int _index;
	private int _currentEvent = 0;
	private List<PlayerEvent[]> _events;
	
	public ReplayPlayer(int id, RefPlayField playField, List<PlayerEvent[]> events, int fromEvent) {		
		super(id, playField);
		System.out.println("id " + id + " starting from event " + fromEvent);
		_currentEvent = fromEvent;
		_events = events;		
		_index = id;
		
	}
	
	@Override
	public FieldDirection getInput() {		
		PlayerEvent ev = _events.get(_currentEvent++)[_index];				
		if (ev == null) {
			System.err.println("Event was null!");
			return null;
		}
		
		FieldDirection fd = ev.toFieldDirection();
		if (fd != null) {
			return fd;
		}		
//		System.err.println("Fd was null");
		
		//sleep for a long time to cause a timeout
		try {			
			while(getRemainingTime() > -100) {
				Thread.sleep(100);
			}
		} catch (InterruptedException e) {
			System.err.println("Sleep failure in ReplayPlayer.");
			e.printStackTrace();
		}
		return FieldDirection.Up; //will never get here...

	}

	
}
