package jp.ac.nii.icpc2010.score;

import jp.ac.nii.icpc2010.Tron;
import jp.ac.nii.icpc2010.playfield.PlayField;

public class SimpleScore extends AbstractScore{
	private int coins;
	private int trail;

	public String toString(){
		return String.format("%3d,%4d", coins, trail);
	}

	public double getValue(){
		return 10 * coins + trail;
	}

	public void add(AbstractScore score){
		this.coins += ((SimpleScore)score).coins;
		this.trail += ((SimpleScore)score).trail;
	}


	public static AbstractScore[] getScores(PlayField playField){
		SimpleScore[] scores = new SimpleScore[playField.getNumOfPlayers()];

		for(int i = 0; i < playField.getNumOfPlayers(); i ++){
			Tron tron = playField.getTron(i);

			scores[i] = new SimpleScore();

			scores[i].coins = tron.getCoins();

			for(int x = 0; x < playField.getWidth(); x++){
				for(int y = 0; y < playField.getHeight(); y++){
					if(playField.getObjectAt(x, y) == PlayField.playerTrail(i)){
						scores[i].trail++;
					}
				}
			}
		}

		return scores;
	}

	@Override
	public int compareTo(AbstractScore score) {
		double a = getValue();
		double b = score.getValue();
		if(a > b){
			return 1;
		}else if(a < b){
			return -1;
		}else{
			return 0;
		}
	}
}
