package jp.ac.nii.icpc2010.submission;
import java.io.File;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;

public class SubmissionUtils {

	private SubmissionUtils() {
//		cal = Calendar.getInstance();
		sdf = new SimpleDateFormat(DATE_FORMAT_NOW);

		try {
			output = new BufferedWriter(new FileWriter("debug.log"));
		}
		catch (Exception e) {

			System.exit(1);
		}
	}

	public static void closeLog() {
		try {
			output.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	static Writer output = null;

	private static SubmissionUtils instance;
	private static SubmissionUtils Instance() 
	{
		if (instance == null)
			instance = new SubmissionUtils();

		return instance;
	}

	public static void error(String msg, Object obj) 
	{
		Instance()._error(msg, obj);
	}

	public static void debug(String msg, Object obj) 
	{
		Instance()._debug(msg, obj);		
	}

	private void _error(String msg, Object obj) 
	{
		System.err.println("[ERROR] <" + (obj == null ? "static" : obj.getClass().getSimpleName()) + "> " + msg);
	}

	SimpleDateFormat sdf;
	String DATE_FORMAT_NOW = "HH:mm:ss";

	private void _debug(String msg, Object obj)
	{
		try {
			System.out.println("[DEBUG] <" + (obj == null ? "static" : obj.getClass().getSimpleName()) + "> " + msg);
			output.write("[DEBUG] <" + (obj == null ? "static" : obj.getClass().getSimpleName()) + "> " + msg + "\n");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static void copy(String fromFileName, String toFileName)
	throws IOException {
		File fromFile = new File(fromFileName);
		File toFile = new File(toFileName);

		if (!fromFile.exists())
			throw new IOException("FileCopy: " + "no such source file: "
					+ fromFileName);
		if (!fromFile.isFile())
			throw new IOException("FileCopy: " + "can't copy directory: "
					+ fromFileName);
		if (!fromFile.canRead())
			throw new IOException("FileCopy: " + "source file is unreadable: "
					+ fromFileName);

		if (toFile.isDirectory())
			toFile = new File(toFile, fromFile.getName());

		if (toFile.exists()) {
			toFile.delete();
		}

		String parent = toFile.getParent();
		if (parent == null)
			parent = System.getProperty("user.dir");
		File dir = new File(parent);
		if (!dir.exists())
			throw new IOException("FileCopy: "
					+ "destination directory doesn't exist: " + parent);
		if (dir.isFile())
			throw new IOException("FileCopy: "
					+ "destination is not a directory: " + parent);
		if (!dir.canWrite())
			throw new IOException("FileCopy: "
					+ "destination directory is unwriteable: " + parent);

		FileInputStream from = null;
		FileOutputStream to = null;
		try {
			from = new FileInputStream(fromFile);
			to = new FileOutputStream(toFile);
			byte[] buffer = new byte[4096];
			int bytesRead;

			while ((bytesRead = from.read(buffer)) != -1)
				to.write(buffer, 0, bytesRead); // write
		} finally {
			if (from != null)
				try {
					from.close();
				} catch (IOException e) {
					;
				}
				if (to != null)
					try {
						to.close();
					} catch (IOException e) {
						;
					}
		}
	}
}
