package jp.ac.nii.icpc2010.tournament;

import java.util.ArrayList;
import java.util.List;

public class Round {
	private int number;
	private List<Group> groups = new ArrayList<Group>();
	
	public Round(int number) {
		this.number = number;
	}
	
	public int getNumber() {
		return number;
	}
	
	public void addGroup(Group g) {
		this.groups.add(g);
	}
	
	public List<Group> getGroups() {
		return groups;
	}
	
	public List<Player> collectProceedingPlayers() {
		List<Player> proceedingPlayers = new ArrayList<Player>();
		for (Group g : groups) {
			proceedingPlayers.addAll(g.getProceedingPlayers());
		}
		return proceedingPlayers;
	}
}
