/*
 * Decompiled with CFR 0.152.
 */
package Lifts;

import Animations.DirectFalling;
import Lifts.BalenceLiftChild;
import Lifts.BasicLift;
import SandBox.Mario;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class BalenceLiftParent
extends Sprite
implements BasicLift {
    boolean MarioOnLift = false;
    Mario game;
    BalenceLiftChild Child;
    int MaxY = 96;
    int MinY = 352;
    double SpeedY = 0.0;
    boolean Break = false;
    Sprite SpriteBlackBoxes;

    public BalenceLiftParent(int x, int y, Mario g, int Distance) {
        this.game = g;
        this.setImage(ImageUtil.TileImage(this.game.bsLoader.getStoredImage("Lift"), 6));
        this.setLocation(x, y);
        this.Child = new BalenceLiftChild(x + 32 * Distance, y, this.game, this);
        this.game.LiftGroup.add(this.Child);
        this.AddChain();
        this.AddBlackBoxes();
        this.AddHooksAndChain(Distance);
    }

    public void update(long elapsedTime) {
        if (!this.Break) {
            if (this.getY() < (double)this.MaxY) {
                this.Break();
                this.Child.Break();
            }
            if (this.getY() > (double)this.MinY) {
                this.Break();
                this.Child.Break();
            }
            if (this.MarioOnLift) {
                this.SpeedY += 0.2;
                if (this.SpeedY > 15.0) {
                    this.SpeedY = 15.0;
                }
                this.game.player.moveY(this.SpeedY / 12.0);
                this.moveY(this.SpeedY / 12.0);
                this.Child.moveY(-this.SpeedY / 12.0);
                this.MarioOnLift = false;
            } else if (!this.MarioOnLift) {
                if (this.SpeedY > 0.0) {
                    this.SpeedY -= 0.2;
                }
                this.Child.moveY(-this.SpeedY / 12.0);
                this.moveY(this.SpeedY / 12.0);
            }
        }
        this.SpriteBlackBoxes.setY(this.getY());
        super.update(elapsedTime);
    }

    public boolean OnLift() {
        return this.MarioOnLift;
    }

    public void render(Graphics2D g) {
        super.render(g);
    }

    public void MarioIsOnLift() {
        this.MarioOnLift = true;
    }

    public void Break() {
        this.game.AnimationGroup.add(new DirectFalling(this.getX(), this.getY(), this.getImage()));
        this.game.AnimationGroup.add(new DirectFalling(this.Child.getX(), this.Child.getY(), this.Child.getImage()));
        this.setActive(false);
        this.Child.setActive(false);
    }

    private void AddChain() {
        BufferedImage Chain = ImageUtil.resize(this.game.bsLoader.getStoredImages("Chain")[0], 32, 480);
        this.game.BackGroundSpriteGroup.add(new Sprite(Chain, this.getX() + 32.0, 96.0));
    }

    private void AddBlackBoxes() {
        BufferedImage BlackBoxes = "Blue".equals(this.game.CurrentLevel.BackGroundColor) ? ImageUtil.createImage(32, 480, this.game.BackGroundColor) : ImageUtil.createImage(32, 480);
        this.SpriteBlackBoxes = new Sprite(BlackBoxes, this.getX() + 32.0, this.getY());
        this.game.BackGroundSpriteGroup.add(this.SpriteBlackBoxes);
    }

    private void AddHooksAndChain(int Distance) {
        int realdis = Distance + 1;
        BufferedImage HooksAndChainimage = "Blue".equals(this.game.CurrentLevel.BackGroundColor) ? ImageUtil.createImage(32 * realdis, 32, this.game.BackGroundColor) : ImageUtil.createImage(32 * realdis, 32);
        Graphics2D g = (Graphics2D)HooksAndChainimage.getGraphics();
        for (int i = 0; i <= realdis; ++i) {
            if (i == 0) {
                g.drawImage(this.game.bsLoader.getStoredImages("Chain")[1], null, i * 32, 0);
                continue;
            }
            if (i == realdis - 1) {
                g.drawImage(this.game.bsLoader.getStoredImages("Chain")[3], null, i * 32, 0);
                continue;
            }
            g.drawImage(this.game.bsLoader.getStoredImages("Chain")[2], null, i * 32, 0);
        }
        g.dispose();
        Sprite HooksAndChain = new Sprite(HooksAndChainimage, this.getX() + 32.0, 64.0);
        this.game.BackGroundSpriteGroup.add(HooksAndChain);
    }
}

