/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.EnemyTurtle;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;

public class FlyingTurtlePatrol
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    int Up = 0;
    int Down = 0;
    private boolean FiyUp = false;
    int DistanceFromCenter = 128;
    int CenterX;
    int CenterY;
    public boolean Green = false;

    public FlyingTurtlePatrol(int x, int y, Mario g, int Length) {
        this.game = g;
        this.setImages(this.game.bsLoader.getStoredImages("FlyingTurtlePatrol"));
        this.setLocation(x, y);
        this.Up = y;
        this.Down = y + 32 * Length;
        this.setID(101);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.CenterY = y + 32 * Length;
    }

    public void update(long l) {
        this.setY(Math.cos(this.game.SlowDistance) * (double)this.DistanceFromCenter + (double)this.CenterY);
        this.moveY(this.game.SlowDistance);
        super.update(l);
    }

    public void bounce() {
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.EnemyGroup.add(new EnemyTurtle((int)this.getX(), (int)this.getY(), this.game, this.Green));
        this.setActive(false);
    }

    public void CollidedWithMovingShell() {
        this.game.parent.amitsAudioPlayer.smb_kick.play();
        BufferedImage HorizontalFilpShell = this.game.bsLoader.getStoredImage("TurtelShellRed");
        HorizontalFilpShell = ImageUtil.flipHorizontal(HorizontalFilpShell);
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), HorizontalFilpShell, this.MariotoRight()));
        this.setActive(false);
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public int getType() {
        return this.getID();
    }

    public void KilledByFireBall() {
        this.CollidedWithMovingShell();
    }

    public void setYloc(double d) {
        this.setY(d);
        this.bounce();
    }

    public void CollidedWithShell() {
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
        } else {
            this.game.player.Decerease();
        }
    }

    public void Kill() {
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }

    private void GoDown() {
        this.FiyUp = false;
    }

    private void GoUp() {
        this.FiyUp = true;
    }
}

