/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.HelmetShell;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;

public class Helmet
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public int Gravity = 5;
    String Color;

    public Helmet(int x, int y, String color, Mario g) {
        this.Color = color;
        this.game = g;
        if ("normal".equals(this.Color)) {
            this.setImages(this.game.bsLoader.getStoredImages("Helmet"));
        } else if ("dark".equals(this.Color)) {
            this.setImages(this.game.bsLoader.getStoredImages("Helmetdark"));
        } else if ("white".equals(this.Color)) {
            this.setImages(this.game.bsLoader.getStoredImages("Helmetwhite"));
        }
        this.setLocation(x, y);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.setID(105);
    }

    public void update(long l) {
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-1.0);
        } else {
            this.moveX(1.0);
        }
        super.update(l);
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.EnemyGroup.add(new HelmetShell(this.getX(), this.getY(), this.Color, this.game, this.MariotoRight()));
        this.setActive(false);
    }

    public void CollidedWithShell() {
    }

    public void CollidedWithMovingShell() {
        this.game.parent.amitsAudioPlayer.smb_kick.play();
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
        this.setActive(false);
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public int getType() {
        return this.getID();
    }

    public void KilledByFireBall() {
    }

    public void bounce() {
    }

    public void setYloc(double d) {
        this.setY(d);
    }

    public void OtherEnemyTouchedFromRight() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void OtherEnemyTouchedFromLeft() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
        this.game.EnemyGroup.add(new HelmetShell(this.getX(), this.getY(), this.Color, this.game, this.MariotoRight()));
        this.setActive(false);
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

