/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class BaseIO {
    public static final int CLASS_URL = 1;
    public static final int WORKING_DIRECTORY = 2;
    public static final int CLASS_LOADER = 3;
    public static final int SYSTEM_LOADER = 4;
    private Class base;
    private ClassLoader loader;
    private int mode;

    public BaseIO(Class base, int mode) {
        this.base = base;
        this.loader = base.getClassLoader();
        this.mode = mode;
    }

    public BaseIO(Class base) {
        this(base, 1);
    }

    public URL getURL(String path, int mode) {
        URL url = null;
        try {
            switch (mode) {
                case 1: {
                    url = this.base.getResource(path);
                    break;
                }
                case 2: {
                    File f = new File(path);
                    if (!f.exists()) break;
                    url = f.toURI().toURL();
                    break;
                }
                case 3: {
                    url = this.loader.getResource(path);
                    break;
                }
                case 4: {
                    url = ClassLoader.getSystemResource(path);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            throw new RuntimeException(this.getException(path, mode, "getURL"));
        }
        return url;
    }

    public URL getURL(String path) {
        URL url = null;
        try {
            url = this.getURL(path, this.mode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            int smart = 0;
            while (url == null && !this.getModeString(++smart).equals("[UNKNOWN-MODE]")) {
                try {
                    url = this.getURL(path, smart);
                }
                catch (Exception e) {}
            }
            if (url == null) {
                throw new RuntimeException(this.getException(path, this.mode, "getURL"));
            }
            this.mode = smart;
        }
        return url;
    }

    public InputStream getStream(String path, int mode) {
        InputStream stream = null;
        try {
            switch (mode) {
                case 1: {
                    stream = this.base.getResourceAsStream(path);
                    break;
                }
                case 2: {
                    stream = new File(path).toURI().toURL().openStream();
                    break;
                }
                case 3: {
                    stream = this.loader.getResourceAsStream(path);
                    break;
                }
                case 4: {
                    stream = ClassLoader.getSystemResourceAsStream(path);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (stream == null) {
            throw new RuntimeException(this.getException(path, mode, "getStream"));
        }
        return stream;
    }

    public InputStream getStream(String path) {
        InputStream stream = null;
        try {
            stream = this.getStream(path, this.mode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (stream == null) {
            int smart = 0;
            while (stream == null && !this.getModeString(++smart).equals("[UNKNOWN-MODE]")) {
                try {
                    stream = this.getStream(path, smart);
                }
                catch (Exception e) {}
            }
            if (stream == null) {
                throw new RuntimeException(this.getException(path, this.mode, "getStream"));
            }
            this.mode = smart;
        }
        return stream;
    }

    public File getFile(String path, int mode) {
        File file = null;
        try {
            switch (mode) {
                case 1: {
                    file = new File(this.base.getResource(path).getFile().replaceAll("%20", " "));
                    break;
                }
                case 2: {
                    file = new File(path);
                    break;
                }
                case 3: {
                    file = new File(this.loader.getResource(path).getFile().replaceAll("%20", " "));
                    break;
                }
                case 4: {
                    file = new File(ClassLoader.getSystemResource(path).getFile().replaceAll("%20", " "));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            throw new RuntimeException(this.getException(path, mode, "getFile"));
        }
        return file;
    }

    public File getFile(String path) {
        File file = null;
        try {
            file = this.getFile(path, this.mode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            int smart = 0;
            while (file == null && !this.getModeString(++smart).equals("[UNKNOWN-MODE]")) {
                try {
                    file = this.getFile(path, smart);
                }
                catch (Exception e) {}
            }
            if (file == null) {
                throw new RuntimeException(this.getException(path, this.mode, "getFile"));
            }
            this.mode = smart;
        }
        return file;
    }

    public File setFile(String path, int mode) {
        File file = null;
        try {
            switch (mode) {
                case 1: {
                    file = new File(this.base.getResource("").getFile().replaceAll("%20", " ") + File.separator + path);
                    break;
                }
                case 2: {
                    file = new File(path);
                    break;
                }
                case 3: {
                    file = new File(this.loader.getResource("").getFile().replaceAll("%20", " ") + File.separator + path);
                    break;
                }
                case 4: {
                    file = new File(ClassLoader.getSystemResource("").getFile().replaceAll("%20", " ") + File.separator + path);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            throw new RuntimeException(this.getException(path, mode, "setFile"));
        }
        return file;
    }

    public File setFile(String path) {
        File file = null;
        try {
            file = this.setFile(path, this.mode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            int smart = 0;
            while (file == null && !this.getModeString(++smart).equals("[UNKNOWN-MODE]")) {
                try {
                    file = this.setFile(path, smart);
                }
                catch (Exception e) {}
            }
            if (file == null) {
                throw new RuntimeException(this.getException(path, this.mode, "setFile"));
            }
            this.mode = smart;
        }
        return file;
    }

    public String getRootPath(int mode) {
        switch (mode) {
            case 1: {
                return this.base.getResource("").toString();
            }
            case 2: {
                return System.getProperty("user.dir") + File.separator;
            }
            case 3: {
                return this.loader.getResource("").toString();
            }
            case 4: {
                return ClassLoader.getSystemResource("").toString();
            }
        }
        return "[UNKNOWN-MODE]";
    }

    public String getModeString(int mode) {
        switch (mode) {
            case 1: {
                return "Class-URL";
            }
            case 2: {
                return "Working-Directory";
            }
            case 3: {
                return "Class-Loader";
            }
            case 4: {
                return "System-Loader";
            }
        }
        return "[UNKNOWN-MODE]";
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected String getException(String path, int mode, String method) {
        return "Resource not found (" + this + "): " + this.getRootPath(mode) + path;
    }

    public void setBase(Class base) {
        this.base = base;
        this.loader = base.getClassLoader();
    }

    public Class getBase() {
        return this.base;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String toString() {
        return super.toString() + " " + "[mode=" + this.getModeString(this.mode) + ", baseClass=" + this.base + ", classLoader=" + this.loader + "]";
    }
}

