/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.funbox;

import com.golden.gamedev.engine.BaseInput;
import java.awt.event.KeyEvent;

public abstract class KeyCapture {
    public BaseInput input;
    public boolean DEBUG = false;
    private int[] key;
    private String keyString;
    private int[] modifiers;
    private int currentKey;
    private int delay;
    private long currentTick;
    private boolean active = true;

    public KeyCapture(BaseInput input, int[] key, int delay) {
        this.input = input;
        this.delay = delay;
        this.key = key;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            buff.append(KeyEvent.getKeyText(key[i]));
        }
        this.keyString = buff.toString();
    }

    public KeyCapture(BaseInput input, String keyString, int delay) {
        this.input = input;
        this.delay = delay;
        this.key = this.parseString(keyString);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.key.length; ++i) {
            buff.append(KeyEvent.getKeyText(this.key[i]));
        }
        this.keyString = buff.toString();
    }

    public int[] getKeySequence() {
        return this.key;
    }

    public String getKeyString() {
        return this.keyString;
    }

    public void setKeySequence(int[] key) {
        this.key = key;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            buff.append(KeyEvent.getKeyText(key[i]));
        }
        this.keyString = buff.toString();
    }

    public void setKeySequence(String st) {
        this.setKeySequence(this.parseString(st));
    }

    private int[] parseString(String st) {
        int[] seq = new int[st.length()];
        st = st.toUpperCase();
        block39: for (int i = 0; i < st.length(); ++i) {
            switch (st.charAt(i)) {
                case 'A': {
                    seq[i] = 65;
                    continue block39;
                }
                case 'B': {
                    seq[i] = 66;
                    continue block39;
                }
                case 'C': {
                    seq[i] = 67;
                    continue block39;
                }
                case 'D': {
                    seq[i] = 68;
                    continue block39;
                }
                case 'E': {
                    seq[i] = 69;
                    continue block39;
                }
                case 'F': {
                    seq[i] = 70;
                    continue block39;
                }
                case 'G': {
                    seq[i] = 71;
                    continue block39;
                }
                case 'H': {
                    seq[i] = 72;
                    continue block39;
                }
                case 'I': {
                    seq[i] = 73;
                    continue block39;
                }
                case 'J': {
                    seq[i] = 74;
                    continue block39;
                }
                case 'K': {
                    seq[i] = 75;
                    continue block39;
                }
                case 'L': {
                    seq[i] = 76;
                    continue block39;
                }
                case 'M': {
                    seq[i] = 77;
                    continue block39;
                }
                case 'N': {
                    seq[i] = 78;
                    continue block39;
                }
                case 'O': {
                    seq[i] = 79;
                    continue block39;
                }
                case 'P': {
                    seq[i] = 80;
                    continue block39;
                }
                case 'Q': {
                    seq[i] = 81;
                    continue block39;
                }
                case 'R': {
                    seq[i] = 82;
                    continue block39;
                }
                case 'S': {
                    seq[i] = 83;
                    continue block39;
                }
                case 'T': {
                    seq[i] = 84;
                    continue block39;
                }
                case 'U': {
                    seq[i] = 85;
                    continue block39;
                }
                case 'V': {
                    seq[i] = 86;
                    continue block39;
                }
                case 'W': {
                    seq[i] = 87;
                    continue block39;
                }
                case 'X': {
                    seq[i] = 88;
                    continue block39;
                }
                case 'Y': {
                    seq[i] = 89;
                    continue block39;
                }
                case 'Z': {
                    seq[i] = 90;
                    continue block39;
                }
                case ' ': {
                    seq[i] = 32;
                    continue block39;
                }
                case '0': {
                    seq[i] = 96;
                    continue block39;
                }
                case '1': {
                    seq[i] = 97;
                    continue block39;
                }
                case '2': {
                    seq[i] = 98;
                    continue block39;
                }
                case '3': {
                    seq[i] = 99;
                    continue block39;
                }
                case '4': {
                    seq[i] = 100;
                    continue block39;
                }
                case '5': {
                    seq[i] = 101;
                    continue block39;
                }
                case '6': {
                    seq[i] = 102;
                    continue block39;
                }
                case '7': {
                    seq[i] = 103;
                    continue block39;
                }
                case '8': {
                    seq[i] = 104;
                    continue block39;
                }
                case '9': {
                    seq[i] = 105;
                    continue block39;
                }
                default: {
                    throw new RuntimeException("Can't parse String st at " + i + " -> " + st.charAt(i) + "\nUse setKeySequence(int[]) instead");
                }
            }
        }
        return seq;
    }

    public int[] getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int[] i) {
        this.modifiers = i;
    }

    public void setModifiers(int i) {
        this.setModifiers(new int[]{i});
    }

    public abstract void keyCaptured();

    public void refresh() {
        this.currentKey = 0;
        this.currentTick = 0L;
    }

    public void update(long elapsedTime) {
        if (!this.active) {
            return;
        }
        this.currentTick += elapsedTime;
        if (this.currentTick > (long)this.delay && this.currentKey > 0) {
            this.printDebugWrong("FAILED: Run out of time, delay time=" + this.delay + "ms");
            this.refresh();
        }
        if (this.modifiers != null) {
            for (int i = 0; i < this.modifiers.length; ++i) {
                if (this.input.isKeyDown(this.modifiers[i])) continue;
                if (this.currentKey > 0) {
                    this.printDebugWrong("FAILED: Modifiers key <" + KeyEvent.getKeyText(this.modifiers[i]) + "> not pressed");
                    this.refresh();
                }
                return;
            }
        }
        if (this.input.getKeyPressed() != Integer.MIN_VALUE) {
            if (this.input.isKeyPressed(this.key[this.currentKey])) {
                this.currentTick = 0L;
                if (++this.currentKey > this.key.length - 1) {
                    this.printDebugRight("SUCCESS: Key Captured");
                    this.keyCaptured();
                    this.refresh();
                }
            } else if (this.currentKey > 0) {
                this.printDebugWrong("FAILED: Wrong key sequence=" + KeyEvent.getKeyText(this.input.getKeyPressed()));
                this.refresh();
                if (this.input.isKeyPressed(this.key[this.currentKey]) && ++this.currentKey > this.key.length - 1) {
                    this.printDebugRight("SUCCESS: Key Captured");
                    this.keyCaptured();
                    this.refresh();
                }
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
        this.refresh();
    }

    public int getDelayTime() {
        return this.delay;
    }

    public void setDelayTime(int i) {
        this.delay = i;
    }

    private void printDebugRight(String st) {
        if (!this.DEBUG || this.currentKey > 0) {
            // empty if block
        }
    }

    private void printDebugWrong(String st) {
        if (this.DEBUG && this.currentKey > 0) {
            System.out.print(st + ", ");
            StringBuffer buff = new StringBuffer();
            buff.append("Current sequence=");
            for (int i = 0; i < this.currentKey; ++i) {
                buff.append(KeyEvent.getKeyText(this.key[i]));
            }
        }
    }

    public String toString() {
        StringBuffer modifierBuff = null;
        if (this.modifiers != null) {
            modifierBuff = new StringBuffer();
            for (int i = 0; i < this.modifiers.length; ++i) {
                modifierBuff.append(this.modifiers[i]);
            }
        }
        return super.toString() + " " + "[keysequence=" + this.keyString + ", modifiers=" + modifierBuff + ", delay=" + this.delay + "]";
    }
}

