/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.Comparator;

public class AdvanceSpriteGroup
extends SpriteGroup {
    protected SpriteGroup ONSCREEN_GROUP;
    private Insets offset;

    public AdvanceSpriteGroup(String name, int topOffset, int leftOffset, int bottomOffset, int rightOffset) {
        super(name);
        this.offset = new Insets(topOffset, leftOffset, bottomOffset, rightOffset);
        this.ONSCREEN_GROUP = new SpriteGroup(name + " #ONSCREEN");
        this.ONSCREEN_GROUP.setExpandFactor(50);
        this.ONSCREEN_GROUP.getScanFrequence().setActive(false);
    }

    public AdvanceSpriteGroup(String name, int screenOffset) {
        this(name, screenOffset, screenOffset, screenOffset, screenOffset);
    }

    public AdvanceSpriteGroup(String name) {
        this(name, 0);
    }

    public void update(long elapsedTime) {
        this.ONSCREEN_GROUP.clear();
        Sprite[] s = this.getGroupSprites();
        int size = this.getGroupSize();
        for (int i = 0; i < size; ++i) {
            if (!s[i].isActive() || !s[i].isOnScreen(this.offset.left, this.offset.top, this.offset.right, this.offset.bottom)) continue;
            this.ONSCREEN_GROUP.add(s[i]);
        }
        this.ONSCREEN_GROUP.update(elapsedTime);
        if (this.getScanFrequence().action(elapsedTime)) {
            this.removeInactiveSprites();
        }
    }

    public void render(Graphics2D g) {
        this.ONSCREEN_GROUP.render(g);
    }

    public void setBackground(Background backgr) {
        super.setBackground(backgr);
        this.ONSCREEN_GROUP.setBackground(backgr);
    }

    public void setComparator(Comparator c) {
        super.setComparator(c);
        this.ONSCREEN_GROUP.setComparator(c);
    }

    public Insets getScreenOffset() {
        return this.offset;
    }

    public Sprite remove(int index) {
        Sprite s = super.remove(index);
        if (s != null) {
            this.ONSCREEN_GROUP.remove(s);
        }
        return s;
    }

    public boolean remove(Sprite s) {
        this.ONSCREEN_GROUP.remove(s);
        return super.remove(s);
    }

    public void clear() {
        super.clear();
        this.ONSCREEN_GROUP.clear();
    }

    public void reset() {
        super.reset();
        this.ONSCREEN_GROUP.reset();
    }

    public Sprite[] getSprites() {
        return this.ONSCREEN_GROUP.getSprites();
    }

    public int getSize() {
        return this.ONSCREEN_GROUP.getSize();
    }

    public Sprite[] getGroupSprites() {
        return super.getSprites();
    }

    public int getGroupSize() {
        return super.getSize();
    }
}

