/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.sprite;

import com.golden.gamedev.object.AnimatedSprite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class AdvanceSprite
extends AnimatedSprite {
    private static final long serialVersionUID = 6163338876818201162L;
    private int[] animationFrame;
    private int status = -1;
    private int direction = -1;

    public AdvanceSprite(BufferedImage[] image, double x, double y) {
        super(image, x, y);
    }

    public AdvanceSprite(BufferedImage[] image) {
        super(image);
    }

    public AdvanceSprite(double x, double y) {
        super(x, y);
    }

    public AdvanceSprite() {
    }

    public void setAnimationFrame(int[] animation) {
        if (this.animationFrame != animation) {
            this.animationFrame = animation;
            this.setAnimationFrame(0, this.animationFrame != null ? this.animationFrame.length - 1 : this.getImages().length - 1);
        }
    }

    public int[] getAnimationFrame() {
        return this.animationFrame;
    }

    public BufferedImage getImage() {
        return this.animationFrame == null ? super.getImage() : this.getImage(this.animationFrame[this.getFrame()]);
    }

    public void setImages(BufferedImage[] image) {
        super.setImages(image);
        if (this.animationFrame != null) {
            this.setAnimationFrame(0, this.animationFrame.length - 1);
        }
    }

    protected void animationChanged(int oldStat, int oldDir, int status, int direction) {
    }

    public void setDirection(int dir) {
        if (this.direction != dir) {
            int oldDir = this.direction;
            this.direction = dir;
            this.animationChanged(this.status, oldDir, this.status, this.direction);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setStatus(int stat) {
        if (this.status != stat) {
            int oldStat = this.status;
            this.status = stat;
            this.animationChanged(oldStat, this.direction, this.status, this.direction);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setAnimation(int stat, int dir) {
        if (this.status != stat || this.direction != dir) {
            int oldStat = this.status;
            int oldDir = this.direction;
            this.status = stat;
            this.direction = dir;
            this.animationChanged(oldStat, oldDir, stat, dir);
        }
    }

    public void render(Graphics2D g, int xs, int ys) {
        if (this.animationFrame != null) {
            g.drawImage((Image)this.getImage(this.animationFrame[this.getFrame()]), xs, ys, null);
        } else {
            super.render(g, xs, ys);
        }
    }
}

