/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.DirectFalling;
import ExtendedObjects.Daze;
import Objects.BasicEnemy;
import Objects.Fire;
import Objects.Hammer;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSprite;
import com.golden.gamedev.util.Utility;
import java.awt.image.BufferedImage;

public class Boss
extends AnimatedSprite
implements BasicEnemy {
    int Life = 4;
    Mario game;
    int left = 64;
    int right = 64;
    boolean PositiveX = true;
    boolean Move = true;
    int DazeState = 0;
    int JumpTime = 20;
    private int Gravity;
    int FireThrowTime;
    private int Delay = 40;
    private boolean GoNearMario = false;
    private boolean Hammer = false;
    private int HammerThrowTime;
    int Hammerxspeed;
    int HammerGravity;
    int hammerThrown;

    public Boss(BufferedImage[] storedImages, int x, int y, Mario g) {
        this.setLocation(x, y);
        this.setImages(storedImages);
        this.setAnimationTimer(new Timer(100));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setID(119);
        this.game = g;
        this.left = x - 96;
        this.right = x + 96;
        this.JumpTime = Utility.getRandom(3, 6) * 20;
        this.FireThrowTime = Utility.getRandom(1, 10) * 10;
        this.HammerThrowTime = Utility.getRandom(1, 10) * 10;
    }

    private void HammerThrow() {
        --this.HammerThrowTime;
        if (this.HammerThrowTime < 0) {
            this.HammerThrowTime = Utility.getRandom(2, 10) * 20;
            this.HammerGravity = Utility.getRandom(-10, -7);
            this.Hammerxspeed = Utility.getRandom(-4, -2);
        }
    }

    private void ContinuousHammerThrow() {
        if (this.HammerThrowTime < 10 && this.game.player.getX() < this.getX()) {
            this.game.HammerGroup.add(new Hammer(this.getX(), this.getY(), this.Hammerxspeed, this.HammerGravity, this.game.bsLoader.getStoredImages("BWHammer")));
            System.out.println(this.hammerThrown++);
        }
    }

    public void update(long l) {
        if (this.DazeState < 1) {
            if (this.Hammer) {
                this.HammerThrow();
                this.ContinuousHammerThrow();
            }
            this.LookAtMario();
            if (this.Gravity < 8) {
                ++this.Gravity;
            }
            this.moveY(this.Gravity);
            if (this.GoNearMario) {
                this.moveX(1.0);
            } else {
                --this.JumpTime;
                if (this.JumpTime < 0) {
                    this.Jump();
                }
            }
            if (!this.GoNearMario) {
                if (this.getX() < (double)this.left) {
                    this.PositiveX = false;
                }
                if (this.getX() > (double)this.right) {
                    this.PositiveX = true;
                }
                if (this.PositiveX) {
                    this.moveX(-1.0);
                } else {
                    this.moveX(1.0);
                }
            }
            this.HammerFire();
            this.MarioToRight();
        }
        if (this.DazeState > 0) {
            if (this.game.player.getX() < this.getX()) {
                this.setAnimationFrame(12, 13);
            } else {
                this.setAnimationFrame(14, 15);
            }
            --this.DazeState;
        } else {
            this.Move = true;
        }
        super.update(l);
    }

    public void CollidedWithBrick_GoToLeft() {
    }

    public void CollidedWithBrick_GoToRight() {
    }

    public int getType() {
        return this.getID();
    }

    public void MarioJumpedOnEnemy() {
        if (this.game.player.HasStar()) {
            this.game.player.Jump(-8);
            this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY()));
            this.game.parent.amitsAudioPlayer.smb_bowserfalls.play();
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
            for (int i = 0; i < this.game.EnemyGroup.getSize(); ++i) {
                if (this.game.EnemyGroup.getSprites()[i] == null) continue;
                this.game.EnemyGroup.getSprites()[i].setActive(false);
            }
        } else {
            this.game.player.Decerease();
        }
    }

    public void KilledByFireBall() {
        int i;
        --this.Life;
        this.DazeState = 30;
        this.Move = false;
        if (this.Life == 0) {
            for (i = 0; i < 10; ++i) {
                this.game.AnimationGroup.add(new Daze(this.game, this));
            }
        }
        if (this.Life < 0) {
            this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY(), -10));
            this.game.parent.amitsAudioPlayer.smb_bowserfalls.play();
            this.setActive(false);
            for (i = 0; i < this.game.EnemyGroup.getSize(); ++i) {
                if (this.game.EnemyGroup.getSprites()[i] == null) continue;
                this.game.EnemyGroup.getSprites()[i].setActive(false);
            }
        }
    }

    public void bounce() {
    }

    public void setYloc(double d) {
        this.setY(d);
    }

    private void LookAtMario() {
        if (this.game.player.getX() < this.getX()) {
            this.setAnimationFrame(0, 3);
        } else {
            this.setAnimationFrame(4, 7);
        }
    }

    private void Jump() {
        if (this.game.player.getX() < this.getX()) {
            this.Gravity = -16;
        }
        this.JumpTime = Utility.getRandom(3, 6) * 20;
    }

    private void HammerFire() {
        --this.FireThrowTime;
        if (this.Delay > 20 & this.Delay < 39) {
            this.setAnimationFrame(8, 8);
        } else if (this.Delay > 0 & this.Delay < 20) {
            this.setAnimationFrame(9, 9);
        }
        if (this.FireThrowTime < 0) {
            if (this.game.player.getX() < this.getX()) {
                --this.Delay;
                if (this.Delay == 20) {
                    this.game.HammerGroup.add(new Fire(this.getX() - 32.0, this.getY() / 32.0 * 32.0, this.game.bsLoader.getStoredImages("Fire"), this.game));
                }
                if (this.Delay < 0) {
                    this.Delay = 40;
                    this.FireThrowTime = Utility.getRandom(5, 10) * 10;
                    this.game.parent.amitsAudioPlayer.smb_bowserfire.play();
                }
            } else {
                this.Delay = 0;
            }
        }
    }

    public void CollidedWithShell() {
    }

    public void CollidedWithMovingShell() {
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY(), -10));
            this.game.parent.amitsAudioPlayer.smb_bowserfalls.play();
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY(), -10));
            this.game.parent.amitsAudioPlayer.smb_bowserfalls.play();
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        this.MarioJumpedOnEnemy();
    }

    private void MarioToRight() {
        this.GoNearMario = this.game.player.getX() > this.getX();
    }

    public int Life() {
        --this.Life;
        return this.Life;
    }

    public void BadGameGlitch() {
        this.setActive(false);
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }

    public void SetHammer(boolean b) {
        this.Hammer = true;
    }
}

