/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.background;

import com.golden.gamedev.object.background.abstraction.AbstractIsometricBackground;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class IsometricBackground
extends AbstractIsometricBackground {
    private static final long serialVersionUID = -2383969026366897057L;
    private transient BufferedImage[] tileImages;
    private int[][] tiles;

    public IsometricBackground(BufferedImage[] tileImages, int[][] tiles, int offsetTileHeight, int startY) {
        super(tiles.length, tiles[0].length, tileImages[0].getWidth(), tileImages[0].getHeight(), offsetTileHeight, startY);
        this.tileImages = tileImages;
        this.tiles = tiles;
    }

    public IsometricBackground(BufferedImage[] tileImages, int[][] tiles) {
        this(tileImages, tiles, 0, 0);
    }

    public IsometricBackground(BufferedImage[] tileImages, int horiz, int vert) {
        this(tileImages, new int[horiz][vert]);
    }

    public void renderTile(Graphics2D g, int tileX, int tileY, int x, int y) {
        int tile = this.tiles[tileX][tileY];
        if (tile >= 0) {
            g.drawImage((Image)this.tileImages[tile], x, y, null);
        }
    }

    public BufferedImage[] getTileImages() {
        return this.tileImages;
    }

    public void setTileImages(BufferedImage[] tileImages, int offsetTileHeight) {
        this.tileImages = tileImages;
        this.setTileSize(tileImages[0].getWidth(), tileImages[0].getHeight(), offsetTileHeight);
    }

    public int[][] getTiles() {
        return this.tiles;
    }

    public void setTiles(int[][] tiles) {
        this.tiles = tiles;
        super.setSize(tiles.length, tiles[0].length);
    }

    public void setSize(int horiz, int vert) {
        if (horiz != this.tiles.length || vert != this.tiles[0].length) {
            int[][] old = this.tiles;
            this.tiles = new int[horiz][vert];
            int minx = Math.min(this.tiles.length, old.length);
            int miny = Math.min(this.tiles[0].length, old[0].length);
            for (int j = 0; j < miny; ++j) {
                for (int i = 0; i < minx; ++i) {
                    this.tiles[i][j] = old[i][j];
                }
            }
        }
        super.setSize(horiz, vert);
    }
}

