/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.background.abstraction;

import com.golden.gamedev.object.Background;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class AbstractIsometricBackground
extends Background {
    private int tileWidth;
    private int baseTileHeight;
    private int halfTileWidth;
    private int halfTileHeight;
    private int offsetTileHeight;
    private int startX;
    private int startY;
    private int tileX;
    private int tileY;
    private int horiz;
    private int vert;
    private Point point1 = new Point();
    private Point point2 = new Point();

    public AbstractIsometricBackground(int horiz, int vert, int tileWidth, int tileHeight, int offsetTileHeight, int startY) {
        super((horiz + vert) * (tileWidth / 2), (horiz + vert) * ((tileHeight - offsetTileHeight) / 2) + startY);
        this.tileWidth = tileWidth;
        this.baseTileHeight = tileHeight - offsetTileHeight;
        this.offsetTileHeight = offsetTileHeight;
        this.halfTileWidth = tileWidth / 2;
        this.halfTileHeight = this.baseTileHeight / 2;
        this.horiz = horiz;
        this.vert = vert;
        this.startX = (vert - 1) * this.halfTileWidth;
        this.startY = startY;
        this.tileY = 0;
        this.tileX = 0;
    }

    public AbstractIsometricBackground(int horiz, int vert, int tileWidth, int tileHeight) {
        this(horiz, vert, tileWidth, tileHeight, 0, 0);
    }

    public void render(Graphics2D g, int xbg, int ybg, int x, int y, int w, int h) {
        int x0 = x - xbg + this.startX;
        int y0 = y - ybg + this.startY - this.offsetTileHeight;
        int x1 = 0;
        int y1 = 0;
        int x2 = x + w;
        int y2 = y + h;
        int xTile = -1;
        int yTile = -1;
        int tileXTemp = this.tileX;
        int skip = 0;
        while (true) {
            y1 = y0;
            ++yTile;
            x1 = x0;
            if ((xTile = --tileXTemp) < -1) {
                xTile = -1;
            }
            y1 += (xTile + 1) * this.halfTileHeight;
            if ((x1 += (xTile + 1) * this.halfTileWidth) + this.tileWidth <= x) {
                skip = (x - (x1 + this.tileWidth)) / this.halfTileWidth + 1;
                xTile += skip;
                x1 += skip * this.halfTileWidth;
                y1 += skip * this.halfTileHeight;
            }
            while (x1 < x2 && y1 < y2 && xTile < this.horiz - 1) {
                ++xTile;
                if (x1 + this.tileWidth > x) {
                    this.renderTile(g, xTile, yTile, x1, y1);
                }
                x1 += this.halfTileWidth;
                y1 += this.halfTileHeight;
            }
            if (yTile >= this.vert - 1) break;
            x0 -= this.halfTileWidth;
            y0 += this.halfTileHeight;
        }
    }

    public abstract void renderTile(Graphics2D var1, int var2, int var3, int var4, int var5);

    public void setLocation(double xb, double yb) {
        int oldx = (int)this.getX();
        int oldy = (int)this.getY();
        super.setLocation(xb, yb);
        int x = (int)this.getX();
        int y = (int)this.getY();
        if (x == oldx && y == oldy) {
            return;
        }
        this.tileX = (y - this.startY) / this.halfTileHeight;
        if (--this.tileX < 0) {
            this.tileX = 0;
        }
        this.tileY = x / this.halfTileWidth;
    }

    public void setTileLocation(int xs, int ys) {
        Point p = this.getCoordinateAt(xs, ys);
        this.setLocation(p.x, p.y);
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public Point getTileAt(double screenX, double screenY) {
        if (screenX < (double)this.getClip().x || screenX > (double)(this.getClip().x + this.getClip().width) || screenY < (double)this.getClip().y || screenY > (double)(this.getClip().y + this.getClip().height)) {
            return null;
        }
        screenX += this.getX() - (double)this.getClip().x;
        this.point1.x = (int)((screenY += this.getY() - (double)this.getClip().y - (double)this.startY) / (double)this.baseTileHeight + (screenX -= (double)(this.vert * this.halfTileWidth)) / (double)this.tileWidth);
        this.point1.y = (int)(screenY / (double)this.baseTileHeight - screenX / (double)this.tileWidth);
        if (this.point1.x < 0 || this.point1.x > this.horiz - 1 || this.point1.y < 0 || this.point1.y > this.vert - 1) {
            return null;
        }
        return this.point1;
    }

    public Point getCoordinateAt(int tileX, int tileY) {
        this.point2.x = this.startX + (tileX - tileY) * this.halfTileWidth;
        this.point2.y = (tileY + tileX) * this.halfTileHeight + this.startY;
        return this.point2;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.baseTileHeight;
    }

    public int getOffsetTileHeight() {
        return this.offsetTileHeight;
    }

    protected void setTileSize(int tileWidth, int tileHeight, int offsetTileHeight) {
        this.tileWidth = tileWidth;
        this.baseTileHeight = tileHeight - offsetTileHeight;
        this.offsetTileHeight = offsetTileHeight;
        this.halfTileWidth = tileWidth / 2;
        this.halfTileHeight = this.baseTileHeight / 2;
        super.setSize((this.horiz + this.vert) * this.halfTileWidth, (this.horiz + this.vert) * this.halfTileHeight + this.startY);
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
        super.setSize((this.horiz + this.vert) * this.halfTileWidth, (this.horiz + this.vert) * this.halfTileHeight + startY);
    }

    public int getTotalHorizontalTiles() {
        return this.horiz;
    }

    public int getTotalVerticalTiles() {
        return this.vert;
    }

    public void setSize(int horiz, int vert) {
        this.horiz = horiz;
        this.vert = vert;
        super.setSize((horiz + vert) * this.halfTileWidth, (horiz + vert) * this.halfTileHeight + this.startY);
    }
}

