/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.Folk;
import biege.GUI;
import biege.Player;
import biege.Position;
import biege.TextBox;
import biege.WorldData;
import java.applet.AudioClip;

public class CrystalGiver
extends Folk {
    private static int WIDTH = 9;
    private static int HEIGHT = 7;
    private static int CRYSTAL_MESSAGE = WorldData.getGiveCrystalMessageIndex();
    private static AudioClip GET_CRYSTAL_SOUND = Element.loadAudioClip("file:sound/get.wav");
    private int crystalId;

    public CrystalGiver(Position p, int id) {
        super(new Position(p.getX() - (double)(WIDTH / 2), p.getY() - (double)(HEIGHT / 2)), CRYSTAL_MESSAGE);
        this.crystalId = id;
    }

    public void talk(GUI tempGui) {
        Player p = tempGui.getPlayer();
        if (!p.hasCystal(this.crystalId)) {
            super.talk(tempGui);
            p.giveCrystal(this.crystalId);
            GET_CRYSTAL_SOUND.play();
        } else if (tempGui.getTextBox() == null) {
            String[] msg = new String[]{"Get lost!", "I already gave you my crystal!"};
            tempGui.setTextBox(new TextBox(msg));
        }
    }

    public double getGurth() {
        return WIDTH;
    }

    public void delete() {
    }
}

