/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.GUI;
import biege.Position;
import java.awt.Color;
import java.awt.Graphics;

public class DownSpike
extends Element {
    private static int WIDTH = 4;
    private static int HEIGHT = 4;
    private static double DASH_RATE = 14.5;
    private static double WALK_RATE = 8.5;
    private boolean canDash = true;

    public DownSpike(Position p) {
        super(p);
    }

    public void draw(Graphics g, int viewW, int viewH) {
        int[] xPts = new int[]{this.scaleX(viewW) - Element.scaleWidth(WIDTH / 2, viewW), this.scaleX(viewW) + Element.scaleWidth(WIDTH / 2, viewW), this.scaleX(viewW)};
        int[] yPts = new int[]{this.scaleY(viewH) - Element.scaleHeight(HEIGHT, viewH), this.scaleY(viewH) - Element.scaleHeight(HEIGHT, viewH), this.scaleY(viewH)};
        g.setColor(Color.white);
        g.fillPolygon(xPts, yPts, 3);
        g.setColor(Color.black);
        g.drawPolygon(xPts, yPts, 3);
    }

    public void interact(Element e) {
        if (Position.distance(this.getPosition(), e.getPosition()) < this.getGurth() + e.getGurth()) {
            e.hurt();
        }
    }

    public void advance(GUI tempGui) {
        double playerX = tempGui.getPlayer().getPosition().getX();
        double playerY = tempGui.getPlayer().getPosition().getY();
        double gurth = tempGui.getPlayer().getGurth();
        if (Math.abs(this.getPosition().getX() - playerX) <= gurth && playerY > this.getPosition().getY() && this.canDash) {
            this.changePosition(Position.calculateNewPosition(this.getPosition(), new Position(this.getPosition().getX(), playerY), DASH_RATE));
        } else if (this.getPosition().getY() > (double)HEIGHT) {
            this.changePosition(Position.calculateNewPosition(this.getPosition(), new Position(this.getPosition().getX(), HEIGHT), WALK_RATE));
            this.canDash = false;
        } else {
            this.canDash = true;
        }
    }

    public boolean isSolid() {
        return false;
    }
}

