/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.GUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JPanel;

public class PlayAreaView
extends JPanel {
    Color BACKGROUND_COLOUR = new Color(255, 245, 235);
    GUI myGui;
    private static int CROSS_WIDTH = 20;
    private static int CROSS_HEIGHT = 20;
    private static int CROSS_THICK = 8;
    private static Image background;
    private static Image MAP;

    public PlayAreaView(GUI caller) {
        this.setBackground(this.BACKGROUND_COLOUR);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.myGui = caller;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Element.drawImage(background, g, 0, 0, this.getWidth(), this.getHeight());
        ArrayList everyThing = this.myGui.getGameParts();
        for (int i = 0; i < everyThing.size(); ++i) {
            ((Element)everyThing.get(i)).draw(g, this.getWidth(), this.getHeight());
        }
        if (this.myGui.isInMapMode()) {
            Element.drawImage(MAP, g, 0, 0, this.getWidth(), this.getHeight());
            double x = ((double)this.myGui.getXScreen() * (double)64 + this.myGui.getPlayer().getPosition().getX() / 200.0 * 64.0) / (double)480 * (double)this.getWidth();
            double y = ((double)this.myGui.getYScreen() * (double)48 + this.myGui.getPlayer().getPosition().getY() / 150.0 * 48.0) / (double)285 * (double)this.getHeight();
            g.setColor(Color.red);
            g.fillOval((int)x, (int)y, 10, 10);
            g.setColor(Color.black);
            g.drawOval((int)x, (int)y, 10, 10);
        } else {
            int cross;
            for (cross = 0; cross < this.myGui.getPlayerHealth(); ++cross) {
                this.showRedCross(g, 5 + cross * (CROSS_WIDTH + 5));
            }
            if (this.myGui.multiplayOn()) {
                for (cross = 0; cross < this.myGui.getPlayer2Health(); ++cross) {
                    this.showBlueCross(g, 5 + cross * (CROSS_WIDTH + 5));
                }
            }
            g.setColor(Color.black);
            g.drawString(String.valueOf("Score: ").concat(String.valueOf(this.myGui.getPlayer().getScore())), 7, this.getHeight() - CROSS_HEIGHT - 21);
            g.setColor(Color.white);
            g.drawString(String.valueOf("Score: ").concat(String.valueOf(this.myGui.getPlayer().getScore())), 8, this.getHeight() - CROSS_HEIGHT - 20);
            if (this.myGui.getTextBox() != null) {
                this.myGui.getTextBox().draw(g, this.getWidth(), this.getHeight() / 4);
            }
        }
    }

    public void showRedCross(Graphics g, int x) {
        g.setColor(Color.red);
        int y = this.getHeight() - CROSS_HEIGHT - 5;
        g.fillRect(x, y + (CROSS_HEIGHT - CROSS_THICK) / 2, CROSS_WIDTH, CROSS_THICK);
        g.fillRect(x + (CROSS_WIDTH - CROSS_THICK) / 2, y, CROSS_THICK, CROSS_HEIGHT);
    }

    public void showBlueCross(Graphics g, int x) {
        g.setColor(Color.blue);
        int y = 5;
        g.fillRect(x, y + (CROSS_HEIGHT - CROSS_THICK) / 2, CROSS_WIDTH, CROSS_THICK);
        g.fillRect(x + (CROSS_WIDTH - CROSS_THICK) / 2, y, CROSS_THICK, CROSS_HEIGHT);
    }

    public static void setBackgroundImage(Image i) {
        background = i;
    }

    static {
        MAP = Element.loadImage("map.gif");
    }
}

