package biege;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class BiegeApplet extends JFrame
{
  private JButton restartButton = new JButton("Restart");
  private JCheckBox twoPlayer = new JCheckBox("2 Player");
  private GUI theGui;

  public BiegeApplet()
  {
    super();

    JPanel temp = new JPanel(new FlowLayout());
    temp.add(restartButton);
    temp.add(twoPlayer);
    this.getContentPane().add(temp);

    restartButton.addActionListener(new RestartListener());
    twoPlayer.addActionListener(new Player2Listener());

    this.addWindowListener(new WindowCloser());
  }

  public void show()
  {
    setSize(100, 100);
    setLocation(0,0);
    theGui = new GUI(twoPlayer.isSelected());
    super.show();
    theGui.show();
  }

  public boolean isTwoPlayer()
  {
    return twoPlayer.isSelected();
  }

  private class RestartListener implements ActionListener
  {
    public void actionPerformed (ActionEvent evt)
    {
      if(theGui != null)
      {
        theGui.closeMe();
        theGui = new GUI(twoPlayer.isSelected());
        theGui.getPlayer().emptyPouch();
        theGui.show();
      }
    }
  }

  private class Player2Listener implements ActionListener
  {
    public void actionPerformed (ActionEvent evt)
    {
      if(theGui != null)
      {
        theGui.closeMe();
        theGui = new GUI(twoPlayer.isSelected());
        theGui.getPlayer().emptyPouch();
        theGui.show();
      }
    }
  }

  private class WindowCloser extends WindowAdapter
  {
    public void windowClosing(WindowEvent e)
    {
      System.out.print("Bye Bye!");
      dispose();
      System.exit(0);
    }
  }

}

