package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.applet.AudioClip;


public class Crystal extends Element
{

    private static String[] MESSAGE = {"You found a crystal!", ""};
    private static int CRYSTAL_WIDTH = 2;
    private static int CRYSTAL_HEIGHT = 3;
    private static AudioClip GET_CRYSTAL_SOUND = Element.loadAudioClip("file:sound/get.wav");
    private int id;

    public Crystal(Position p, int i)
    {
      super(p);
      id = i;
    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      int[] xPts = new int[4];
        xPts[0] = scaleX(viewW);
        xPts[1] = scaleX(viewW) + Element.scaleWidth(CRYSTAL_WIDTH, viewW);
        xPts[2] = scaleX(viewW);
        xPts[3] = scaleX(viewW) - Element.scaleWidth(CRYSTAL_WIDTH, viewW);

      int[] yPts = new int[4];
        yPts[0] = scaleY(viewH) - Element.scaleHeight(CRYSTAL_HEIGHT, viewH);
        yPts[1] = scaleY(viewH);
        yPts[2] = scaleY(viewH) + Element.scaleHeight(CRYSTAL_HEIGHT, viewH);
        yPts[3] = scaleY(viewH);

      g.setColor(Color.blue);
      g.fillPolygon(xPts, yPts, 4);

      g.setColor(Color.black);
      g.drawPolygon(xPts, yPts, 4);

    }

    public void interact(Element e)
    {

      if (e.hasCystal(id))
        this.delete();
    }

    public void advance(GUI tempGui)
    {
      if (Position.distance(getPosition(), tempGui.getPlayer().getPosition()) < getGurth() + tempGui.getPlayer().getGurth())
        talk(tempGui);
    }

    public void talk (GUI tempGui)
    {
      Player p = tempGui.getPlayer();

      if (!p.hasCystal(id))
      {
        if (GET_CRYSTAL_SOUND != null)
          GET_CRYSTAL_SOUND.play();

        p.giveCrystal(id);
        tempGui.setTextBox(new TextBox(MESSAGE));
        this.delete();
      }
    }

    public double getGurth()
    {
      return Math.max(CRYSTAL_WIDTH, CRYSTAL_HEIGHT)/2;
    }
}