package biege;

import java.awt.*;
import javax.swing.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class GUI extends JFrame
{
  private AdventureApp app;
  private PlayAreaView viewer;
  private ScrollView scroll;
  private Container contents;

  private static boolean pressingUp = false;
  private static boolean pressingDown = false;
  private static boolean pressingLeft = false;
  private static boolean pressingRight = false;
  private static boolean pressingControl = false;
  private static boolean pressingSpace = false;
  private static boolean pressingM = false;
  private static boolean pressingShift = false;
  private static boolean pressingW = false;
  private static boolean pressingS = false;
  private static boolean pressingA = false;
  private static boolean pressingD = false;

  private boolean mapMode = false;
  private double myScrollX;
  private double myScrollY;
  private double myScrollDeltaX;
  private double myScrollDeltaY;
  private double myScrollEndX;
  private double myScrollEndY;


  private static int FLOW_DELAY = 66;

  private Timer gameTimer;
  private Timer scrollTimer;

  private TextBox dialogue = null;

  public GUI(boolean player2On)
  {
    super("Adventure Game Biege");
    setLocation(100,100);
    setSize(640, 480);

    pressingUp = false;
    pressingDown = false;
    pressingLeft = false;
    pressingRight = false;
    pressingControl = false;
    pressingShift = false;
    pressingW = false;
    pressingS = false;
    pressingA = false;
    pressingD = false;
    pressingSpace = false;

    viewer = new PlayAreaView(this);
    app = new AdventureApp(this, player2On);

    contents = getContentPane();
    viewer.setSize(getSize());
    contents.add(viewer);
    addKeyListener(new KeyCapture());
    addWindowListener(new WindowCloser());

    gameTimer = new Timer(FLOW_DELAY, new Tick());
    scrollTimer = new Timer(FLOW_DELAY, new ScrollTick());
    gameTimer.start();
    gameTimer.stop();
    scrollTimer.stop();
    gameTimer.start();
  }

  public void show()
  {
    setCursor(Cursor.CROSSHAIR_CURSOR);
    super.show();
  }


  public void loadBackgrounds()
  {
  }

  public boolean multiplayOn()
  {
    return app.twoPlayer();
  }

  public void setTextBox(TextBox t)
  {
    dialogue = t;
  }

  public TextBox getTextBox()
  {
    return dialogue;
  }

  public static boolean isUpPressed()
  {
    return pressingUp;
  }

  public static boolean isDownPressed()
  {
    return pressingDown;
  }

  public static boolean isLeftPressed()
  {
    return pressingLeft;
  }

  public static boolean isRightPressed()
  {
    return pressingRight;
  }

  public static boolean isControlPressed()
  {
    return pressingControl;
  }

  public static boolean isSpacePressed()
  {
    return pressingSpace;
  }

  public static boolean isShiftPressed()
  {
    return pressingShift;
  }

  public static boolean isWPressed()
  {
    return pressingW;
  }

  public static boolean isSPressed()
  {
    return pressingS;
  }

  public static boolean isAPressed()
  {
    return pressingA;
  }

  public static boolean isDPressed()
  {
    return pressingD;
  }

  public boolean isInMapMode()
  {
    return mapMode;
  }

  public int getXScreen()
  {
    return app.getXScreen();
  }

  public int getYScreen()
  {
    return app.getYScreen();
  }

  public int getPlayerHealth()
  {
    return app.getPlayerHealth();
  }

  public int getPlayer2Health()
  {
    return app.getPlayer2Health();
  }

  public ArrayList getGameParts()
  {
      return app.getGameParts();
  }

  public void showHealthDisplay (int health)
  {

  }

  public void setScreen(int x, int y)
  {
    app.setScreen(x,y);
  }

  public GUI getMe()
  {
    return this;
  }

  public void closeMe()
  {
    WorldData.stopSong();
    WorldData.changeSong("");
    gameTimer.stop();
    app.getPlayer().emptyPouch();
    dispose();
  }

  private class Tick implements ActionListener
  {
    public void actionPerformed (ActionEvent e)
    {

      app.advance();
      repaint();
    }

  }

  private class ScrollTick implements ActionListener
  {
    public void actionPerformed (ActionEvent e)
    {

      scroll.changeX(myScrollDeltaX);
      scroll.changeY(myScrollDeltaY);
      myScrollX += myScrollDeltaX;
      myScrollY += myScrollDeltaY;

      if (myScrollX == myScrollEndX && myScrollY == myScrollEndY)
      {
        contents.remove(scroll);
        contents.add(viewer);
        scrollTimer.stop();
        gameTimer.restart();

      }
      repaint();
    }

  }

  public void ScrollAround (Image offImg, double startX, double startY,
                            double relX, double relY, double deltaX, double deltaY,
                            double endX, double endY)
  {
    gameTimer.stop();
    contents.remove(viewer);
    scroll = new ScrollView(this, offImg, viewer.getBackgroundImage(), startX, startY, relX, relY);
    contents.add(scroll);

    myScrollX = startX;
    myScrollY = startY;
    myScrollDeltaX = deltaX;
    myScrollDeltaY = deltaY;
    myScrollEndX = endX;
    myScrollEndY = endY;

    scrollTimer.restart();
    this.show();
  }

  public PlayAreaView getView()
  {
    return viewer;
  }

  private JFrame me ()
  {
    return this;
  }

  private class KeyCapture implements KeyListener
  {
    public void keyPressed (KeyEvent key)
    {

      int keyId = key.getKeyCode();

      if (keyId == KeyEvent.VK_UP)
        pressingUp = true;
      else if (keyId == KeyEvent.VK_DOWN)
         pressingDown = true;
      else if (keyId == KeyEvent.VK_LEFT)
         pressingLeft = true;
      else if (keyId == KeyEvent.VK_RIGHT)
         pressingRight = true;
      else if (keyId == KeyEvent.VK_CONTROL)
         pressingControl = true;
      else if (keyId == KeyEvent.VK_SPACE)
         pressingSpace = true;
      else if (keyId == KeyEvent.VK_SHIFT)
          pressingShift = true;
      else if (keyId == KeyEvent.VK_W)
          pressingW = true;
      else if (keyId == KeyEvent.VK_S)
          pressingS = true;
      else if (keyId == KeyEvent.VK_A)
          pressingA = true;
      else if (keyId == KeyEvent.VK_D)
          pressingD = true;
      else if (keyId == KeyEvent.VK_M)
      {
        if (!pressingM)
          mapMode = !mapMode;

        pressingM = true;
      }

      if (keyId == KeyEvent.VK_ENTER)
      {
          mapMode = false;
          dialogue = null;
          /*if (app.gameIsOver())
          {
            closeMe();
          }*/
      }

    }



    public void keyTyped (KeyEvent key) { }

    public void keyReleased (KeyEvent key)
    {
      int keyId = key.getKeyCode();

      if (keyId == KeyEvent.VK_UP)
        pressingUp = false;
      else if (keyId == KeyEvent.VK_DOWN)
         pressingDown = false;
      else if (keyId == KeyEvent.VK_LEFT)
         pressingLeft = false;
      else if (keyId == KeyEvent.VK_RIGHT)
         pressingRight = false;
      if (keyId == KeyEvent.VK_SHIFT)
      {
         pressingShift = false;
         Player2.getReadyToSmite();
      }
      else if (keyId == KeyEvent.VK_W)
         pressingW = false;
      else if (keyId == KeyEvent.VK_S)
         pressingS = false;
      else if (keyId == KeyEvent.VK_A)
         pressingA = false;
      else if (keyId == KeyEvent.VK_D)
         pressingD = false;
      else if (keyId == KeyEvent.VK_CONTROL)
      {
         pressingControl = false;
         Player.getReadyToSmite();
      }
      else if (keyId == KeyEvent.VK_SPACE)
         pressingSpace = false;
      else if (keyId == KeyEvent.VK_M)
         pressingM = false;


    }

  }

  public Player getPlayer()
  {
    return app.getPlayer();
  }

  public Player2 getPlayer2()
  {
    return app.getPlayer2();
  }

  private class WindowCloser extends WindowAdapter
  {
    public void windowClosing(WindowEvent e)
    {
      System.out.print("Bye Bye!");
      getMe().closeMe();
    }

  }



}