package biege;
import java.awt.Graphics;
import java.awt.Color;


public class Projectile extends Element
{

    private static int WIDTH = 1;

    private double dx;
    private double dy;
    private double r;
    private Color c;

    public Projectile(Position p, double deltax, double deltay, double radius, Color colour)
    {
      super(p);
      dx = deltax;
      dy = deltay;
      r = radius;
      c = colour;
    }

    public void draw(Graphics g, int viewW, int viewH)
    {

      g.setColor(c);
     g.fillOval(scaleX(viewW) - Element.scaleWidth(viewW, (int)r/2),
                 scaleY(viewH) - Element.scaleHeight(viewH, (int)r/2),
                 Element.scaleWidth(viewW, (int)r),Element.scaleHeight(viewH, (int)r) );
    }

    public void interact(Element e)
    {
      if (Position.distance(getPosition(), e.getPosition()) < e.getGurth() + r)
        e.hurt();
    }

    public void advance(GUI tempGui)
    {
      Position current = getPosition();
      Position newPos = new Position(current.getX() + dx, current.getY() + dy);
      changePosition(newPos);

      if (getPosition().getX() <= AdventureApp.LEFT ||
          getPosition().getX() >= AdventureApp.RIGHT ||
          getPosition().getY() <= AdventureApp.TOP ||
          getPosition().getY() >= AdventureApp.BOTTOM)
          delete();
    }

    public double getGurth()
    {
      return r;
    }

    public void talk (GUI tempGuip) { }

    public boolean isSolid()
    {
      return false;
    }
}