package biege;
import java.awt.Graphics;
import java.awt.Color;


public class RectangleObstacle extends Element
{

    private int width;
    private int height;
    private Color colour;

    public RectangleObstacle(Position p, int w, int h, Color c)
    {
      super(p);
      width = w;
      height = h;
      colour = c;
    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      if (colour != null)
      {
        g.setColor(colour);
        g.fillRect(scaleX(viewW), scaleY(viewH),
                  Element.scaleWidth(viewW, width), Element.scaleHeight(viewH, height));
      }
    }

    public void interact(Element e)
    {
      double west = getPosition().getX() - e.getGurth();
      double east = getPosition().getX() + width + e.getGurth();
      double north = getPosition().getY() - e.getGurth();
      double south = getPosition().getY() + height +  e.getGurth();

      if (e.isSolid() && Position.isInRectangle(e.getPosition(), new Position(west, north), new Position (east, south)))
        e.changePosition(Position.closestRectangleIntersection(e.getPosition(), west, north, east, south));

    }

    public void advance(GUI tempGui)
    {
    }

    public void talk (GUI tempGui) { }
}