package biege;
import java.awt.Graphics;
import java.awt.Color;


public class WarpHome extends Element
{

    private int width;
    private int height;

    public WarpHome(Position p, int w, int h)
    {
      super(p);
      width = w;
      height = h;
    }

    public void interact (Element e) {}

    public void draw(Graphics g, int viewW, int viewH) {}

    public void advance(GUI tempGui)
    {
      super.advance(tempGui);
      Player p = tempGui.getPlayer();

      double west = getPosition().getX() - p.getGurth();
      double east = getPosition().getX() + width + p.getGurth();
      double north = getPosition().getY() - p.getGurth();
      double south = getPosition().getY() + height +  p.getGurth();

      if (Position.isInRectangle(p.getPosition(), new Position(west, north), new Position (east, south)))
      {
        p.changePosition(new Position(100, 120));
        p.fullHeal();
        tempGui.setScreen(0,1);
        this.delete();
      }

    }
}
