/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.crypto;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.SecureRandom;
import marauroa.common.crypto.Hash;
import marauroa.common.crypto.RSAPublicKey;

public class RSAKey
extends RSAPublicKey {
    private final BigInteger d;

    public RSAKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(bigInteger, bigInteger3);
        this.d = bigInteger2;
    }

    public void print(PrintWriter printWriter) {
        super.print(printWriter);
        printWriter.println("d = " + this.d);
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        printStream.println("d = " + this.d);
    }

    public static RSAKey generateKey(int n) {
        BigInteger bigInteger = new BigInteger("15");
        byte[] byArray = new byte[n / 16 + 1];
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.nextBytes(byArray);
        }
        catch (Exception exception) {
            System.err.println("Can't happen...");
            exception.printStackTrace();
        }
        if (byArray[0] >= 0) {
            byArray[0] = (byte)(byArray[0] - 128);
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        bigInteger2 = bigInteger2.subtract(bigInteger2.remainder(big6)).subtract(big1);
        BigInteger bigInteger3 = bigInteger2.subtract(big6);
        while (!bigInteger2.isProbablePrime(1000) || !bigInteger2.multiply(big2).add(big1).isProbablePrime(1000)) {
            bigInteger2 = bigInteger2.add(big6);
        }
        while (!bigInteger3.isProbablePrime(1000) || !bigInteger3.multiply(big2).add(big1).isProbablePrime(1000)) {
            bigInteger3 = bigInteger3.subtract(big6);
        }
        bigInteger2 = bigInteger2.multiply(big2).add(big1);
        bigInteger3 = bigInteger3.multiply(big2).add(big1);
        BigInteger bigInteger4 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger5 = bigInteger2.subtract(big1);
        BigInteger bigInteger6 = bigInteger3.subtract(big1);
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6);
        while (!bigInteger.gcd(bigInteger7).equals(big1)) {
            bigInteger = bigInteger.add(big1);
        }
        BigInteger bigInteger8 = bigInteger.modInverse(bigInteger7);
        return new RSAKey(bigInteger4, bigInteger8, bigInteger);
    }

    public BigInteger decode(BigInteger bigInteger) {
        return bigInteger.modPow(this.d, this.n);
    }

    public byte[] decodeByteArray(byte[] byArray) {
        return Hash.bigIntToBytes(this.decode(new BigInteger(byArray)));
    }

    public BigInteger sign(BigInteger bigInteger) {
        return this.decode(bigInteger);
    }

    public RSAPublicKey getPublicKey() {
        return new RSAPublicKey(this.n, this.e);
    }

    public BigInteger getD() {
        return this.d;
    }
}

