/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.crypto;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import marauroa.common.crypto.Hash;
import org.apache.log4j.Logger;

public class RSAPublicKey {
    private static final Logger logger = Logger.getLogger(RSAPublicKey.class);
    public static final BigInteger big0 = new BigInteger("0");
    public static final BigInteger big1 = new BigInteger("1");
    public static final BigInteger big2 = new BigInteger("2");
    public static final BigInteger big6 = new BigInteger("6");
    protected BigInteger n;
    protected BigInteger e;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n = bigInteger;
        this.e = bigInteger2;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("n = " + this.n);
        printWriter.println("e = " + this.e);
    }

    public void print(PrintStream printStream) {
        printStream.println("n = " + this.n);
        printStream.println("e = " + this.e);
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getE() {
        return this.e;
    }

    public BigInteger encode(BigInteger bigInteger) {
        return bigInteger.modPow(this.e, this.n);
    }

    public byte[] encodeByteArray(byte[] byArray) {
        return this.encode(Hash.bytesToBigInt(byArray)).toByteArray();
    }

    public boolean verifySignature(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.equals(this.encode(bigInteger2));
    }

    public static BigInteger getValue(String string) {
        try {
            byte[] byArray;
            for (byte by : byArray = string.getBytes("US-ASCII")) {
                if (by == 0) continue;
                return new BigInteger(1, byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
        }
        return big0;
    }

    public static String getString(BigInteger bigInteger) {
        try {
            return new String(bigInteger.toByteArray(), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
            return null;
        }
    }
}

