/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Definition;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import marauroa.common.game.SlotOwner;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;

public class RPEvent
extends SlotOwner {
    private static final Logger logger = Log4J.getLogger(RPEvent.class);
    private String name;
    private RPObject owner;

    public RPEvent(String string) {
        super(RPClass.getRPClass(string));
        this.name = string;
    }

    public RPEvent() {
        super(RPClass.getBaseRPObjectDefault());
    }

    public Object clone() {
        try {
            RPEvent rPEvent = (RPEvent)super.clone();
            rPEvent.fill(this);
            return rPEvent;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error(cloneNotSupportedException, cloneNotSupportedException);
            return null;
        }
    }

    public void fill(RPEvent rPEvent) {
        super.fill(rPEvent);
        this.name = rPEvent.name;
        this.owner = rPEvent.owner;
    }

    public void setOwner(RPObject rPObject) {
        this.owner = rPObject;
    }

    public String getName() {
        return this.name;
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        this.writeObject(outputSerializer, DetailLevel.NORMAL);
    }

    public void writeObject(OutputSerializer outputSerializer, DetailLevel detailLevel) throws IOException {
        RPClass rPClass = this.owner.getRPClass();
        Definition definition = rPClass.getDefinition(Definition.DefinitionClass.RPEVENT, this.name);
        short s = definition.getCode();
        if (detailLevel == DetailLevel.FULL) {
            s = -1;
        }
        outputSerializer.write(s);
        if (s == -1) {
            outputSerializer.write255LongString(this.name);
        }
        super.writeObject(outputSerializer, detailLevel);
        RPClass rPClass2 = this.getRPClass();
        if (rPClass2.hasAnyDefinition(Definition.DefinitionClass.RPSLOT)) {
            this.serializeRPSlots(outputSerializer, detailLevel);
        }
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        RPClass rPClass;
        short s = inputSerializer.readShort();
        if (s == -1) {
            this.name = inputSerializer.read255LongString();
        } else {
            rPClass = this.owner.getRPClass();
            this.name = rPClass.getName(Definition.DefinitionClass.RPEVENT, s);
        }
        super.readObject(inputSerializer);
        rPClass = this.getRPClass();
        if (rPClass.hasAnyDefinition(Definition.DefinitionClass.RPSLOT)) {
            this.deserializeRPSlots(inputSerializer);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + super.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RPEvent) {
            RPEvent rPEvent = (RPEvent)object;
            return this.name.equals(rPEvent.name) && super.equals(this);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("RPEvent " + this.name + " with ");
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    SlotOwner getContainerBaseOwner() {
        return null;
    }

    SlotOwner getContainerOwner() {
        return null;
    }

    void setContainer(SlotOwner slotOwner, RPSlot rPSlot) {
    }
}

