/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import marauroa.common.io.Persistence;

public class WebstartPersistence
extends Persistence {
    private PersistenceService ps = null;
    private BasicService bs = null;
    private URL codebase = null;

    public WebstartPersistence() {
        try {
            this.ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            this.bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            if (this.ps != null && this.bs != null) {
                this.codebase = this.bs.getCodeBase();
            }
        }
        catch (UnavailableServiceException unavailableServiceException) {
            unavailableServiceException.printStackTrace(System.err);
            this.ps = null;
            this.bs = null;
        }
    }

    public InputStream getInputStream(boolean bl, String string, String string2) throws IOException {
        URL uRL = new URL(this.codebase.toString() + string2);
        FileContents fileContents = this.ps.get(uRL);
        InputStream inputStream = fileContents.getInputStream();
        return inputStream;
    }

    public OutputStream getOutputStream(boolean bl, String string, String string2) throws IOException {
        URL uRL = new URL(this.codebase.toString() + string2);
        try {
            this.ps.delete(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ps.create(uRL, 5000L);
        FileContents fileContents = this.ps.get(uRL);
        OutputStream outputStream = fileContents.getOutputStream(false);
        return outputStream;
    }
}

