/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net;

import java.io.IOException;
import java.io.OutputStream;

public class ByteCounterOutputStream
extends OutputStream {
    private OutputStream os;
    private long bytesWritten;

    public ByteCounterOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream is null!!!");
        }
        this.os = outputStream;
        this.bytesWritten = 0L;
    }

    public void write(int n) throws IOException {
        this.os.write(n);
        ++this.bytesWritten;
    }

    public void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
        this.bytesWritten += (long)byArray.length;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void close() throws IOException {
        this.os.close();
    }
}

