/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Utility;
import marauroa.common.game.Attributes;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SAction;
import marauroa.common.net.message.MessageC2SChooseCharacter;
import marauroa.common.net.message.MessageC2SCreateAccount;
import marauroa.common.net.message.MessageC2SCreateCharacter;
import marauroa.common.net.message.MessageC2SKeepAlive;
import marauroa.common.net.message.MessageC2SLoginRequestKey;
import marauroa.common.net.message.MessageC2SLoginSendNonceNameAndPassword;
import marauroa.common.net.message.MessageC2SLoginSendNonceNamePasswordAndSeed;
import marauroa.common.net.message.MessageC2SLoginSendPromise;
import marauroa.common.net.message.MessageC2SLoginSendUsernameAndPassword;
import marauroa.common.net.message.MessageC2SLogout;
import marauroa.common.net.message.MessageC2SOutOfSync;
import marauroa.common.net.message.MessageC2STransferACK;
import marauroa.common.net.message.MessageC2SUpdateResponse;
import marauroa.common.net.message.MessageP2SCreateAccount;
import marauroa.common.net.message.MessageP2SCreateCharacter;
import marauroa.common.net.message.MessageS2CCharacterList;
import marauroa.common.net.message.MessageS2CChooseCharacterACK;
import marauroa.common.net.message.MessageS2CChooseCharacterNACK;
import marauroa.common.net.message.MessageS2CConnectNACK;
import marauroa.common.net.message.MessageS2CCreateAccountACK;
import marauroa.common.net.message.MessageS2CCreateAccountNACK;
import marauroa.common.net.message.MessageS2CCreateCharacterACK;
import marauroa.common.net.message.MessageS2CCreateCharacterNACK;
import marauroa.common.net.message.MessageS2CInvalidMessage;
import marauroa.common.net.message.MessageS2CLoginACK;
import marauroa.common.net.message.MessageS2CLoginMessageNACK;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.common.net.message.MessageS2CLoginSendKey;
import marauroa.common.net.message.MessageS2CLoginSendNonce;
import marauroa.common.net.message.MessageS2CLogoutACK;
import marauroa.common.net.message.MessageS2CLogoutNACK;
import marauroa.common.net.message.MessageS2CPerception;
import marauroa.common.net.message.MessageS2CServerInfo;
import marauroa.common.net.message.MessageS2CTransfer;
import marauroa.common.net.message.MessageS2CTransferREQ;
import marauroa.common.net.message.MessageS2CUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFactory {
    private static final Logger logger = Log4J.getLogger(Attributes.class);
    private static Map<Integer, Class<?>> factoryArray;
    private static MessageFactory messageFactory;

    private MessageFactory() {
        this.register();
    }

    public static MessageFactory getFactory() {
        if (messageFactory == null) {
            factoryArray = new HashMap();
            messageFactory = new MessageFactory();
        }
        return messageFactory;
    }

    private void register() {
        this.register(Message.MessageType.C2S_ACTION, MessageC2SAction.class);
        this.register(Message.MessageType.C2S_CHOOSECHARACTER, MessageC2SChooseCharacter.class);
        this.register(Message.MessageType.C2S_LOGOUT, MessageC2SLogout.class);
        this.register(Message.MessageType.S2C_CHARACTERLIST, MessageS2CCharacterList.class);
        this.register(Message.MessageType.S2C_CHOOSECHARACTER_ACK, MessageS2CChooseCharacterACK.class);
        this.register(Message.MessageType.S2C_CHOOSECHARACTER_NACK, MessageS2CChooseCharacterNACK.class);
        this.register(Message.MessageType.S2C_LOGIN_ACK, MessageS2CLoginACK.class);
        this.register(Message.MessageType.S2C_LOGIN_NACK, MessageS2CLoginNACK.class);
        this.register(Message.MessageType.S2C_LOGOUT_ACK, MessageS2CLogoutACK.class);
        this.register(Message.MessageType.S2C_LOGOUT_NACK, MessageS2CLogoutNACK.class);
        this.register(Message.MessageType.S2C_PERCEPTION, MessageS2CPerception.class);
        this.register(Message.MessageType.C2S_OUTOFSYNC, MessageC2SOutOfSync.class);
        this.register(Message.MessageType.C2S_KEEPALIVE, MessageC2SKeepAlive.class);
        this.register(Message.MessageType.S2C_SERVERINFO, MessageS2CServerInfo.class);
        this.register(Message.MessageType.S2C_INVALIDMESSAGE, MessageS2CInvalidMessage.class);
        this.register(Message.MessageType.S2C_TRANSFER_REQ, MessageS2CTransferREQ.class);
        this.register(Message.MessageType.C2S_TRANSFER_ACK, MessageC2STransferACK.class);
        this.register(Message.MessageType.S2C_TRANSFER, MessageS2CTransfer.class);
        this.register(Message.MessageType.C2S_LOGIN_REQUESTKEY, MessageC2SLoginRequestKey.class);
        this.register(Message.MessageType.C2S_LOGIN_SENDNONCENAMEANDPASSWORD, MessageC2SLoginSendNonceNameAndPassword.class);
        this.register(Message.MessageType.S2C_LOGIN_SENDKEY, MessageS2CLoginSendKey.class);
        this.register(Message.MessageType.S2C_LOGIN_SENDNONCE, MessageS2CLoginSendNonce.class);
        this.register(Message.MessageType.C2S_LOGIN_SENDPROMISE, MessageC2SLoginSendPromise.class);
        this.register(Message.MessageType.C2S_CREATEACCOUNT, MessageC2SCreateAccount.class);
        this.register(Message.MessageType.S2C_CREATEACCOUNT_ACK, MessageS2CCreateAccountACK.class);
        this.register(Message.MessageType.S2C_CREATEACCOUNT_NACK, MessageS2CCreateAccountNACK.class);
        this.register(Message.MessageType.C2S_CREATECHARACTER, MessageC2SCreateCharacter.class);
        this.register(Message.MessageType.S2C_CREATECHARACTER_ACK, MessageS2CCreateCharacterACK.class);
        this.register(Message.MessageType.S2C_CREATECHARACTER_NACK, MessageS2CCreateCharacterNACK.class);
        this.register(Message.MessageType.S2C_CONNECT_NACK, MessageS2CConnectNACK.class);
        this.register(Message.MessageType.C2S_LOGIN_SENDNONCENAMEPASSWORDANDSEED, MessageC2SLoginSendNonceNamePasswordAndSeed.class);
        this.register(Message.MessageType.S2C_LOGIN_MESSAGE_NACK, MessageS2CLoginMessageNACK.class);
        this.register(Message.MessageType.P2S_CREATECHARACTER, MessageP2SCreateCharacter.class);
        this.register(Message.MessageType.P2S_CREATEACCOUNT, MessageP2SCreateAccount.class);
        this.register(Message.MessageType.C2S_LOGIN_SENDUSERNAMEANDPASSWORD, MessageC2SLoginSendUsernameAndPassword.class);
        this.register(Message.MessageType.S2C_UPDATE, MessageS2CUpdate.class);
        this.register(Message.MessageType.C2S_UPDATE_RESPONSE, MessageC2SUpdateResponse.class);
    }

    private void register(Message.MessageType messageType, Class<?> clazz) {
        factoryArray.put(messageType.ordinal(), clazz);
    }

    public Message getMessage(byte[] byArray) throws IOException, InvalidVersionException {
        return this.getMessage(byArray, 0);
    }

    public Message getMessage(byte[] byArray, int n) throws IOException, InvalidVersionException {
        byte by = byArray[n];
        if (by < 31 || by > 80) {
            logger.error("Message has incorrect protocol version (" + by + ") expected (" + 31 + " < x < " + 80 + ")");
            logger.error("Message is: " + Utility.dumpByteArray(byArray));
            throw new InvalidVersionException(byArray[n]);
        }
        byte by2 = byArray[n + 1];
        if (factoryArray.containsKey(by2)) {
            Message message = null;
            try {
                Class<?> clazz = factoryArray.get(by2);
                message = (Message)clazz.newInstance();
                message.setProtocolVersion(by);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (n > 0) {
                    byteArrayInputStream.skip(n);
                }
                InputSerializer inputSerializer = new InputSerializer(byteArrayInputStream);
                inputSerializer.setProtocolVersion(by);
                message.readObject(inputSerializer);
                inputSerializer.close();
                return message;
            }
            catch (Exception exception) {
                logger.error("error in getMessage", exception);
                throw new IOException(exception.getMessage());
            }
        }
        logger.warn("Message type [" + by2 + "] is not registered in the MessageFactory");
        throw new IOException("Message type [" + by2 + "] is not registered in the MessageFactory");
    }

    public Message getMessage(Map<String, Object> map) throws IOException {
        byte by = Byte.parseByte((String)map.get("t"));
        if (factoryArray.containsKey(by)) {
            Message message = null;
            try {
                Class<?> clazz = factoryArray.get(by);
                message = (Message)clazz.newInstance();
                message.readFromMap(map);
                return message;
            }
            catch (Exception exception) {
                logger.error("error in getMessage", exception);
                throw new IOException(exception.getMessage());
            }
        }
        logger.warn("Message type [" + by + "] is not registered in the MessageFactory");
        throw new IOException("Message type [" + by + "] is not registered in the MessageFactory");
    }
}

