/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.IOException;
import java.util.Map;
import marauroa.common.game.RPAction;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageC2SAction
extends Message {
    private RPAction action;
    byte priority = (byte)-1;

    public MessageC2SAction() {
        super(Message.MessageType.C2S_ACTION, null);
    }

    public MessageC2SAction(Channel channel, RPAction rPAction) {
        super(Message.MessageType.C2S_ACTION, channel);
        this.action = rPAction;
    }

    public RPAction getRPAction() {
        return this.action;
    }

    public byte getPriority() {
        return this.priority;
    }

    @Override
    public String toString() {
        return "Message (C2S Action) from (" + this.getAddress() + ") CONTENTS: (" + this.action.toString() + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        this.action.writeObject(outputSerializer);
        try {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getActiveWindow();
            outputSerializer.write((byte)(window == null ? 1 : 0));
        }
        catch (HeadlessException headlessException) {
            outputSerializer.write((byte)2);
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.action = (RPAction)inputSerializer.readObject(new RPAction());
        if (inputSerializer.available() >= 1) {
            this.priority = inputSerializer.readByte();
        }
        if (this.type != Message.MessageType.C2S_ACTION) {
            throw new IOException();
        }
    }

    @Override
    public void readFromMap(Map<String, Object> map) throws IOException {
        super.readFromMap(map);
        this.action = new RPAction();
        this.action.readFromMap((Map)map.get("a"));
        if (map.get("p") != null) {
            this.priority = Byte.parseByte((String)map.get("p"));
        }
        if (this.type != Message.MessageType.C2S_ACTION) {
            throw new IOException();
        }
    }
}

