/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.command;

import java.io.IOException;
import java.sql.SQLException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.i18n.I18N;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.db.command.DBCommandMetaData;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.dbcommand.DBCommandWithCallback;
import org.apache.log4j.MDC;

class DBCommandQueueBackgroundThread
implements Runnable {
    private static Logger logger = Log4J.getLogger(DBCommandQueueBackgroundThread.class);

    DBCommandQueueBackgroundThread() {
    }

    public void run() {
        DBCommandQueue dBCommandQueue = DBCommandQueue.get();
        while (true) {
            DBCommandMetaData dBCommandMetaData = null;
            try {
                dBCommandMetaData = dBCommandQueue.getNextCommand();
            }
            catch (InterruptedException interruptedException) {
                logger.error(interruptedException, interruptedException);
            }
            if (dBCommandMetaData != null) {
                try {
                    this.processCommand(dBCommandMetaData);
                }
                catch (RuntimeException runtimeException) {
                    logger.error(runtimeException, runtimeException);
                }
                continue;
            }
            if (dBCommandQueue.isFinished()) break;
        }
    }

    private void processCommand(DBCommandMetaData dBCommandMetaData) {
        MDC.put((String)"context", (Object)(dBCommandMetaData + " "));
        if (TransactionPool.get() == null) {
            logger.warn("Database not initialized, skipping database operation");
            return;
        }
        for (int i = 0; i < 5 && !this.executeDBAction(dBCommandMetaData); ++i) {
            logger.warn("Retrying DBCommand " + dBCommandMetaData);
        }
        if (dBCommandMetaData.getCommand() instanceof DBCommandWithCallback) {
            DBCommandWithCallback dBCommandWithCallback = (DBCommandWithCallback)dBCommandMetaData.getCommand();
            dBCommandWithCallback.invokeCallback();
        }
        if (dBCommandMetaData.isResultAwaited()) {
            dBCommandMetaData.setProcessedTimestamp(System.currentTimeMillis());
            DBCommandQueue.get().addResult(dBCommandMetaData);
        }
        MDC.put((String)"context", (Object)"");
    }

    private boolean executeDBAction(DBCommandMetaData dBCommandMetaData) {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            I18N.setThreadLocale(dBCommandMetaData.getLocale());
            dBCommandMetaData.getCommand().execute(dBTransaction);
            TransactionPool.get().commit(dBTransaction);
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
            I18N.resetThreadLocale();
            TransactionPool.get().rollback(dBTransaction);
            dBCommandMetaData.getCommand().setException(iOException);
        }
        catch (SQLException sQLException) {
            logger.error(sQLException, sQLException);
            I18N.resetThreadLocale();
            if (sQLException.toString().contains("CommunicationsException") || sQLException.toString().contains("Query execution was interrupted")) {
                TransactionPool.get().killTransaction(dBTransaction);
                TransactionPool.get().refreshAvailableTransaction();
                return false;
            }
            TransactionPool.get().rollback(dBTransaction);
            dBCommandMetaData.getCommand().setException(sQLException);
        }
        catch (RuntimeException runtimeException) {
            logger.error(runtimeException, runtimeException);
            I18N.resetThreadLocale();
            TransactionPool.get().rollback(dBTransaction);
            dBCommandMetaData.getCommand().setException(runtimeException);
        }
        I18N.resetThreadLocale();
        return true;
    }
}

