/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.container;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.message.TransferContent;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.SecuredLoginInfo;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.LoginEventDAO;
import marauroa.server.game.dbcommand.StoreCharacterCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerEntry {
    private static Logger logger = Log4J.getLogger(PlayerEntry.class);
    public long creationTime;
    public ClientState state;
    public int clientid;
    public Channel channel;
    public SecuredLoginInfo loginInformations;
    public String username;
    public String character;
    public RPObject object;
    public Locale locale = Locale.ENGLISH;
    public long activityTimestamp;
    private static final long TIMEOUT_IN_GAME_MILLISECONDS = 30000L;
    private static final long TIMEOUT_PRE_GAME_MILLISECONDS = 600000L;
    public int perceptionCounter;
    public boolean requestedSync;
    public List<TransferContent> contentToTransfer;
    private int protocolVersion = 35;
    private boolean gotKeepAliveInGameState = false;
    public int characterCounter;
    private boolean checkTimeout = true;

    public PlayerEntry(Channel channel) {
        this.channel = channel;
        this.clientid = -1;
        this.state = ClientState.CONNECTION_ACCEPTED;
        this.loginInformations = null;
        this.username = null;
        this.character = null;
        this.object = null;
        this.perceptionCounter = 0;
        this.requestedSync = true;
        this.contentToTransfer = Collections.synchronizedList(new LinkedList());
        this.activityTimestamp = this.creationTime = System.currentTimeMillis();
    }

    public InetAddress getAddress() {
        return this.channel.getInetSocketAddress().getAddress();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.channel.getInetSocketAddress();
    }

    public boolean isTimeout() {
        if (!this.checkTimeout) {
            return false;
        }
        if (this.state == ClientState.GAME_BEGIN) {
            if (this.gotKeepAliveInGameState) {
                return System.currentTimeMillis() - this.activityTimestamp > 30000L;
            }
            return System.currentTimeMillis() - this.activityTimestamp > 120000L;
        }
        return System.currentTimeMillis() - this.activityTimestamp > 600000L;
    }

    public void disableTimeout() {
        this.checkTimeout = false;
    }

    public void update() {
        this.activityTimestamp = System.currentTimeMillis();
        if (this.state == ClientState.GAME_BEGIN) {
            this.gotKeepAliveInGameState = true;
        }
    }

    public int getPerceptionTimestamp() {
        return this.perceptionCounter++;
    }

    public int getThisPerceptionTimestamp() {
        return this.perceptionCounter;
    }

    public void removeContent(TransferContent transferContent) {
        if (!this.contentToTransfer.remove(transferContent)) {
            logger.warn("Trying to clean unknown content: " + transferContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferContent getContent(String string) {
        if (this.contentToTransfer == null) {
            logger.warn("contentToTransfer is null.");
            return null;
        }
        List<TransferContent> list = this.contentToTransfer;
        synchronized (list) {
            for (TransferContent transferContent : this.contentToTransfer) {
                if (!transferContent.name.equals(string)) continue;
                return transferContent;
            }
        }
        logger.warn("content " + string + " not found.");
        return null;
    }

    public void storeRPObject(RPObject rPObject) throws SQLException, IOException {
        this.object = rPObject;
        StoreCharacterCommand storeCharacterCommand = new StoreCharacterCommand(this.username, this.character, rPObject);
        DBCommandQueue.get().enqueue(storeCharacterCommand);
    }

    public boolean hasCharacter(String string) throws SQLException {
        return DAORegister.get().get(CharacterDAO.class).hasCharacter(this.username, string);
    }

    public void ban() throws SQLException {
        DAORegister.get().get(AccountDAO.class).setAccountStatus(this.username, "banned");
    }

    public void setObject(RPObject rPObject) {
        this.object = rPObject;
    }

    public List<String> getCharacters() throws SQLException {
        return DAORegister.get().get(CharacterDAO.class).getCharacters(this.username);
    }

    public void requestSync() {
        this.requestedSync = true;
    }

    public List<String> getPreviousLogins() throws SQLException {
        return DAORegister.get().get(LoginEventDAO.class).getLoginEvents(this.username, 1);
    }

    boolean isRemovable() {
        boolean bl = this.state == ClientState.GAME_BEGIN;
        return !bl && System.currentTimeMillis() - this.creationTime > 60000L;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int n) {
        this.protocolVersion = Math.min(35, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PlayerEntry");
        stringBuilder.append("[clientid=" + this.clientid + "]");
        stringBuilder.append("[channel=" + this.channel + "]");
        stringBuilder.append("[state=" + (Object)((Object)this.state) + "]");
        stringBuilder.append("[username=" + this.username + "]");
        stringBuilder.append("[character=" + this.character + "]");
        stringBuilder.append("[object defined=" + (this.object != null) + "]");
        return stringBuilder.toString();
    }
}

