/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SChooseCharacter;
import marauroa.common.net.message.MessageS2CChooseCharacterACK;
import marauroa.common.net.message.MessageS2CChooseCharacterNACK;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.dbcommand.LoadActiveCharacterCommand;
import marauroa.server.game.dbcommand.LoadCharacterCommand;
import marauroa.server.game.messagehandler.DelayedEventHandler;
import marauroa.server.game.messagehandler.MessageHandler;
import marauroa.server.game.rp.RPServerManager;

class ChooseCharacterHandler
extends MessageHandler
implements DelayedEventHandler {
    private static final Logger logger = Log4J.getLogger(ChooseCharacterHandler.class);

    ChooseCharacterHandler() {
    }

    public void process(Message message) {
        MessageC2SChooseCharacter messageC2SChooseCharacter = (MessageC2SChooseCharacter)message;
        try {
            int n = messageC2SChooseCharacter.getClientID();
            PlayerEntry playerEntry = this.playerContainer.get(n);
            if (!this.isValidEvent(messageC2SChooseCharacter, playerEntry, ClientState.LOGIN_COMPLETE, ClientState.GAME_BEGIN)) {
                return;
            }
            playerEntry.character = messageC2SChooseCharacter.getCharacter();
            PlayerEntry playerEntry2 = this.playerContainer.getOldEntry(playerEntry);
            if (playerEntry2 != null) {
                if (playerEntry2.state == ClientState.GAME_BEGIN) {
                    this.reownOldEntry(playerEntry2, playerEntry);
                    return;
                }
                logger.warn("Old PlayerEntry exists but is not in state GAME_BEGIN: " + playerEntry2);
                this.rejectClient(messageC2SChooseCharacter.getChannel(), n, playerEntry);
                this.playerContainer.getLock().requestWriteLock();
                logger.debug("Disconnecting " + playerEntry.channel + " with " + playerEntry + " because there is a unexpected old entry.");
                this.netMan.disconnectClient(playerEntry.channel);
                this.playerContainer.remove(playerEntry.clientid);
                this.playerContainer.getLock().releaseLock();
                return;
            }
            this.loadAndPlaceInWorld(messageC2SChooseCharacter, n, playerEntry);
        }
        catch (Exception exception) {
            logger.error("error when processing character event", exception);
        }
    }

    private void reownOldEntry(PlayerEntry playerEntry, PlayerEntry playerEntry2) {
        this.playerContainer.getLock().requestWriteLock();
        RPObject rPObject = playerEntry.object;
        this.rpMan.onTimeout(playerEntry.object);
        logger.debug("Disconnecting PREVIOUS " + playerEntry.channel + " with " + playerEntry);
        this.netMan.disconnectClient(playerEntry.channel);
        this.playerContainer.remove(playerEntry.clientid);
        rPObject = DAORegister.get().getRPObjectFactory().transform(rPObject);
        this.completeLoadingCharacterIntoWorld(this.rpMan, playerEntry2.clientid, playerEntry2.channel, playerEntry2, rPObject);
        this.playerContainer.getLock().releaseLock();
    }

    private void loadAndPlaceInWorld(MessageC2SChooseCharacter messageC2SChooseCharacter, int n, PlayerEntry playerEntry) {
        LoadActiveCharacterCommand loadActiveCharacterCommand = new LoadActiveCharacterCommand(playerEntry.username, playerEntry.character, this, n, messageC2SChooseCharacter.getChannel(), messageC2SChooseCharacter.getProtocolVersion());
        DBCommandQueue.get().enqueue(loadActiveCharacterCommand);
    }

    public void handleDelayedEvent(RPServerManager rPServerManager, Object object) {
        LoadCharacterCommand loadCharacterCommand = (LoadCharacterCommand)object;
        RPObject rPObject = loadCharacterCommand.getObject();
        int n = loadCharacterCommand.getClientid();
        PlayerEntry playerEntry = this.playerContainer.get(n);
        if (playerEntry == null) {
            return;
        }
        if (rPObject == null) {
            logger.warn("could not load object for character " + playerEntry.character + " for user " + loadCharacterCommand.getUsername() + " from database");
            this.rejectClient(loadCharacterCommand.getChannel(), n, playerEntry);
            return;
        }
        PlayerEntry playerEntry2 = this.playerContainer.getOldEntry(playerEntry);
        if (playerEntry2 != null) {
            logger.warn("Old PlayerEntry exists but is not in state GAME_BEGIN: " + playerEntry2);
            this.rejectClient(playerEntry.channel, n, playerEntry);
            this.playerContainer.getLock().requestWriteLock();
            logger.debug("Disconnecting " + playerEntry.channel + " with " + playerEntry + " because there is a unexpected old entry.");
            this.netMan.disconnectClient(playerEntry.channel);
            this.playerContainer.remove(playerEntry.clientid);
            this.playerContainer.getLock().releaseLock();
            return;
        }
        this.playerContainer.getLock().requestWriteLock();
        this.completeLoadingCharacterIntoWorld(rPServerManager, n, loadCharacterCommand.getChannel(), playerEntry, rPObject);
        this.playerContainer.getLock().releaseLock();
    }

    private void completeLoadingCharacterIntoWorld(RPServerManager rPServerManager, int n, Channel channel, PlayerEntry playerEntry, RPObject rPObject) {
        if (rPObject != null) {
            rPObject.put("#clientid", n);
        }
        playerEntry.setObject(rPObject);
        if (rPServerManager.onInit(rPObject)) {
            MessageS2CChooseCharacterACK messageS2CChooseCharacterACK = new MessageS2CChooseCharacterACK(channel);
            messageS2CChooseCharacterACK.setClientID(n);
            messageS2CChooseCharacterACK.setProtocolVersion(playerEntry.getProtocolVersion());
            this.netMan.sendMessage(messageS2CChooseCharacterACK);
            playerEntry.state = ClientState.GAME_BEGIN;
        } else {
            logger.warn("RuleProcessor rejected character(" + playerEntry.character + ")");
            this.rejectClient(channel, n, playerEntry);
        }
    }

    private void rejectClient(Channel channel, int n, PlayerEntry playerEntry) {
        playerEntry.state = ClientState.LOGIN_COMPLETE;
        MessageS2CChooseCharacterNACK messageS2CChooseCharacterNACK = new MessageS2CChooseCharacterNACK(channel);
        messageS2CChooseCharacterNACK.setClientID(n);
        messageS2CChooseCharacterNACK.setProtocolVersion(playerEntry.getProtocolVersion());
        this.netMan.sendMessage(messageS2CChooseCharacterNACK);
    }
}

