/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.flood;

import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.Channel;
import marauroa.server.net.IDisconnectedListener;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.flood.FloodMeasure;
import marauroa.server.net.flood.IFloodCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloodValidator
implements IDisconnectedListener,
Iterable<FloodMeasure> {
    private static final Logger logger = Log4J.getLogger(FloodValidator.class);
    private INetworkServerManager netMan;
    private Map<Channel, FloodMeasure> connections;
    private IFloodCheck floodCheck;

    public FloodValidator(INetworkServerManager iNetworkServerManager, IFloodCheck iFloodCheck) {
        this.netMan = iNetworkServerManager;
        this.floodCheck = iFloodCheck;
        this.connections = new HashMap<Channel, FloodMeasure>();
    }

    public void add(Channel channel) {
        this.connections.put(channel, new FloodMeasure(channel));
    }

    @Override
    public void onDisconnect(Channel channel) {
        this.connections.remove(channel);
    }

    public boolean isFlooding(SocketChannel socketChannel, int n) {
        FloodMeasure floodMeasure = this.connections.get(this.netMan.getChannel(socketChannel));
        if (floodMeasure == null) {
            logger.warn("This connection is not registered. Impossible: " + socketChannel);
            return true;
        }
        floodMeasure.addMessage(n);
        boolean bl = this.floodCheck.isFlooding(floodMeasure);
        if (bl) {
            logger.info("Connection determined to be flooding");
            floodMeasure.warning();
        }
        return bl;
    }

    public void onFlood(SocketChannel socketChannel) {
        FloodMeasure floodMeasure = this.connections.get(this.netMan.getChannel(socketChannel));
        if (floodMeasure == null) {
            logger.warn("This connection is not registered. Impossible: " + socketChannel);
            return;
        }
        this.floodCheck.onFlood(floodMeasure);
    }

    @Override
    public Iterator<FloodMeasure> iterator() {
        return this.connections.values().iterator();
    }
}

