/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Utility;
import marauroa.common.net.Channel;
import marauroa.common.net.ConnectionManager;
import marauroa.common.net.Decoder;
import marauroa.common.net.Encoder;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageS2CConnectNACK;
import marauroa.common.net.message.MessageS2CInvalidMessage;
import marauroa.server.game.Statistics;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.IServerManager;
import marauroa.server.net.flood.FloodValidator;
import marauroa.server.net.nio.DataEvent;
import marauroa.server.net.nio.FloodCheck;
import marauroa.server.net.nio.IWorker;
import marauroa.server.net.nio.NioServer;

public final class NIONetworkConnectionManager
extends Thread
implements IWorker,
ConnectionManager {
    private static final Logger logger = Log4J.getLogger(NIONetworkConnectionManager.class);
    private NioServer server;
    private boolean keepRunning;
    private boolean isFinished;
    private final Statistics stats;
    private final FloodValidator floodValidator;
    private final BlockingQueue<DataEvent> queue;
    private final Encoder encoder;
    private final Decoder decoder;
    private final IServerManager serverManager;

    public NIONetworkConnectionManager(IServerManager iServerManager) throws IOException {
        super("NetworkServerManager");
        FloodCheck floodCheck = new FloodCheck((INetworkServerManager)((Object)iServerManager));
        this.floodValidator = new FloodValidator((INetworkServerManager)((Object)iServerManager), floodCheck);
        this.keepRunning = true;
        this.isFinished = false;
        this.encoder = Encoder.get();
        this.decoder = Decoder.get();
        this.stats = Statistics.getStatistics();
        this.queue = new LinkedBlockingQueue<DataEvent>();
        logger.debug("NetworkServerManager started successfully");
        Configuration configuration = Configuration.getConfiguration();
        int n = Integer.parseInt(configuration.get("tcp_port"));
        this.server = new NioServer(null, n, this);
        this.server.start();
        iServerManager.registerDisconnectedListener(this.floodValidator);
        this.serverManager = iServerManager;
    }

    public void setServer(NioServer nioServer) {
        this.server = nioServer;
    }

    public void finish() {
        logger.debug("shutting down NetworkServerManager");
        this.keepRunning = false;
        this.server.finish();
        this.interrupt();
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void onConnect(SocketChannel socketChannel) {
        Channel channel = this.serverManager.onConnect(this, (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress(), socketChannel);
        if (channel != null) {
            this.floodValidator.add(channel);
        } else {
            MessageS2CConnectNACK messageS2CConnectNACK = new MessageS2CConnectNACK();
            this.send(socketChannel, messageS2CConnectNACK, true);
            this.server.close(socketChannel);
        }
    }

    public void onData(NioServer nioServer, SocketChannel socketChannel, byte[] byArray, int n) {
        logger.debug("Received from channel:" + socketChannel + " " + n + " bytes");
        this.stats.add("Bytes recv", n);
        this.stats.add("Message recv", 1);
        if (this.floodValidator.isFlooding(socketChannel, n)) {
            logger.warn("Channel: " + socketChannel + " is flooding");
            this.floodValidator.onFlood(socketChannel);
        } else {
            logger.debug("queueing message");
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            try {
                this.queue.put(new DataEvent(socketChannel, byArray2));
            }
            catch (InterruptedException interruptedException) {
                logger.error("Not expected", interruptedException);
            }
        }
    }

    public void send(Object object, Message message, boolean bl) {
        if (!bl && message.isSkippable() && message.getProtocolVersion() >= 34) {
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("send message(type=" + (Object)((Object)message.getType()) + ") from " + message.getClientID() + " full [" + message + "]");
            }
            byte[] byArray = this.encoder.encode(message);
            this.stats.add("Bytes send", byArray.length);
            this.stats.add("Message send", 1);
            this.server.send((SocketChannel)object, byArray);
        }
        catch (IOException iOException) {
            logger.debug(iOException, iOException);
        }
    }

    public void close(Object object) {
        try {
            this.server.close((SocketChannel)object);
        }
        catch (Exception exception) {
            logger.error("Unable to disconnect a client " + ((SocketChannel)object).socket(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.keepRunning) {
                DataEvent dataEvent = this.queue.take();
                try {
                    List<Message> list = this.decoder.decode(dataEvent.channel, dataEvent.data);
                    if (list == null) continue;
                    for (Message message : list) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("recv message(type=" + (Object)((Object)message.getType()) + ") from " + message.getClientID() + " full [" + message + "]");
                        }
                        this.serverManager.onMessage(this, dataEvent.channel, message);
                    }
                }
                catch (InvalidVersionException invalidVersionException) {
                    logger.warn("Invalid version message: \n" + Utility.dumpByteArray(dataEvent.data), invalidVersionException);
                    logger.warn("sender was: " + dataEvent.channel.socket().getRemoteSocketAddress());
                    this.stats.add("Message invalid version", 1);
                    MessageS2CInvalidMessage messageS2CInvalidMessage = new MessageS2CInvalidMessage(null, "Invalid client version: Update client");
                    messageS2CInvalidMessage.setProtocolVersion(invalidVersionException.getProtocolVersion());
                    this.send(dataEvent.channel, messageS2CInvalidMessage, true);
                }
                catch (IOException iOException) {
                    logger.warn("IOException while building message:\n" + Utility.dumpByteArray(dataEvent.data), iOException);
                    logger.warn("sender was: " + dataEvent.channel.socket().getRemoteSocketAddress());
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("RuntimeException while building message:\n" + Utility.dumpByteArray(dataEvent.data), runtimeException);
                    logger.warn("sender was: " + dataEvent.channel.socket().getRemoteSocketAddress());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.warn(this.getName() + " interrupted. Finishing network layer.");
            this.keepRunning = false;
        }
        this.isFinished = true;
    }

    public void onDisconnect(SocketChannel socketChannel) {
        logger.info("NET Disconnecting " + socketChannel.socket().getRemoteSocketAddress());
        this.decoder.clear(socketChannel);
        this.serverManager.onDisconnect(this, socketChannel);
    }
}

