/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.EntityViewManager;
import games.stendhal.client.GameObjects;
import games.stendhal.client.IGameScreen;
import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.Zone;
import games.stendhal.client.entity.Corpse;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Item;
import games.stendhal.client.gui.DropTarget;
import games.stendhal.client.gui.EffectLayer;
import games.stendhal.client.gui.GroundContainer;
import games.stendhal.client.gui.j2d.AchievementBoxFactory;
import games.stendhal.client.gui.j2d.RemovableSprite;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.spellcasting.SpellCastingGroundContainerMouseState;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.image.VolatileImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public class GameScreen
extends JComponent
implements IGameScreen,
DropTarget,
GameObjects.GameObjectListener,
StendhalClient.ZoneChangeListener {
    private static final long serialVersionUID = -4070406295913030925L;
    private static final Logger logger = Logger.getLogger(GameScreen.class);
    private static final Map<Integer, Integer> keyEventMapping = new HashMap<Integer, Integer>();
    private static final int PAN_SCALE = 8;
    private static final int PAN_INERTIA = 15;
    private static final int OFFLINE_MARGIN = 10;
    private static final Sprite offlineIcon;
    private static GameScreen screen;
    private final StaticGameLayers gameLayers;
    private static final Collection<EffectLayer> globalEffects;
    private final EntityViewManager viewManager = new EntityViewManager();
    private int ww;
    private int wh;
    private final GroundContainer ground;
    private final List<RemovableSprite> texts;
    private final List<RemovableSprite> staticSprites;
    private boolean offline;
    private int blinkOffline;
    private int x;
    private int y;
    private int sw;
    private int sh;
    private int dvx;
    private int dvy;
    private int svx;
    private int svy;
    private int speed;
    private double scale = 1.0;
    private boolean useScaling = true;
    private boolean useTripleBuffer;
    private VolatileImage buffer;
    private AchievementBoxFactory achievementBoxFactory;

    public GameScreen(StendhalClient stendhalClient) {
        this.setSize(stendhal.getDisplaySize());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GameScreen.this.onResized();
            }
        });
        this.gameLayers = stendhalClient.getStaticGameLayers();
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        this.x = 0;
        this.y = 0;
        this.svx = -this.sw / 2;
        this.svy = -this.sh / 2;
        this.dvx = 0;
        this.dvy = 0;
        this.speed = 0;
        this.texts = Collections.synchronizedList(new LinkedList());
        this.staticSprites = Collections.synchronizedList(new LinkedList());
        this.ground = new GroundContainer(stendhalClient, this, this);
        this.addMouseListener(this.ground);
        this.addMouseWheelListener(this.ground);
        this.addMouseMotionListener(this.ground);
        this.setIgnoreRepaint(true);
        stendhalClient.getGameObjects().addGameObjectListener(this);
    }

    private void onResized() {
        Dimension dimension = stendhal.getDisplaySize();
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        if (this.useScaling) {
            double d = (double)this.sw / dimension.getWidth();
            double d2 = (double)this.sh / dimension.getHeight();
            this.scale = Math.max(d, d2);
            if (Math.abs(this.scale - 1.0) > 1.0E-4) {
                this.useTripleBuffer = true;
            } else {
                this.useTripleBuffer = false;
                this.buffer = null;
            }
        } else {
            this.sw = Math.min(this.sw, dimension.width);
            this.sh = Math.min(this.sh, dimension.height);
            this.useTripleBuffer = false;
            this.buffer = null;
        }
        this.calculateView(this.x, this.y);
        this.center();
    }

    public void setUseScaling(boolean bl) {
        this.useScaling = bl;
        if (!bl) {
            this.scale = 1.0;
            this.useTripleBuffer = false;
            this.buffer = null;
        } else {
            this.onResized();
        }
    }

    public boolean isScaled() {
        return this.useScaling;
    }

    public static void setDefaultScreen(GameScreen gameScreen) {
        screen = gameScreen;
    }

    public static GameScreen get() {
        return screen;
    }

    private int getViewWidth() {
        return (int)Math.ceil((double)this.sw / (32.0 * this.scale));
    }

    private int getViewHeight() {
        return (int)Math.ceil((double)this.sh / (32.0 * this.scale));
    }

    @Override
    public void nextFrame() {
        this.adjustView();
    }

    private AchievementBoxFactory getAchievementFactory() {
        if (this.achievementBoxFactory == null) {
            this.achievementBoxFactory = new AchievementBoxFactory();
        }
        return this.achievementBoxFactory;
    }

    @Override
    public void addEntity(IEntity iEntity) {
        EntityView<IEntity> entityView = this.viewManager.addEntity(iEntity);
        if (entityView != null) {
            if (entityView instanceof Entity2DView) {
                Entity2DView entity2DView = (Entity2DView)entityView;
                entity2DView.setInspector(this.ground);
            }
            if (iEntity.isUser()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GameScreen.this.center();
                    }
                });
            }
        }
    }

    public void addEffect(final EffectLayer effectLayer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                globalEffects.add(effectLayer);
            }
        });
    }

    @Override
    public void removeEntity(IEntity iEntity) {
        this.viewManager.removeEntity(iEntity);
    }

    private void adjustView() {
        if (this.dvx == 0 && this.dvy == 0) {
            return;
        }
        int n = this.convertWorldXToScaledScreen(this.x) - this.getScreenViewX() + 16;
        int n2 = this.convertWorldYToScaledScreen(this.y) - this.getScreenViewY() + 16;
        if (n < 0 || n >= this.sw || n2 < -32 || n2 > this.sh) {
            this.center();
        } else {
            this.calculatePanningSpeed();
            if (this.speed != 0) {
                int n3 = (Math.abs(this.dvx) + Math.abs(this.dvy)) * 8;
                int n4 = this.speed * this.dvx / n3;
                int n5 = this.speed * this.dvy / n3;
                if (this.dvx < 0) {
                    n4 = MathHelper.clamp(n4, this.dvx, -1);
                } else if (this.dvx > 0) {
                    n4 = MathHelper.clamp(n4, 1, this.dvx);
                }
                if (this.dvy < 0) {
                    n5 = MathHelper.clamp(n5, this.dvy, -1);
                } else if (this.dvy > 0) {
                    n5 = MathHelper.clamp(n5, 1, this.dvy);
                }
                this.svx += n4;
                this.dvx -= n4;
                this.svy += n5;
                this.dvy -= n5;
            }
        }
    }

    private void calculatePanningSpeed() {
        int n = this.dvx / 15;
        int n2 = this.dvy / 15;
        int n3 = (n * n + n2 * n2) * 8;
        if (this.speed > n3) {
            this.speed = (2 * this.speed + n3) / 3;
            if (this.dvx != 0 || this.dvy != 0) {
                this.speed = Math.max(this.speed, 1);
            }
        } else if (this.speed < n3) {
            this.speed += 2;
        }
    }

    private void calculateView(int n, int n2) {
        int n3 = (int)((double)(n * 32 + 16) - (double)(this.sw / 2) / this.scale);
        int n4 = (int)((double)(n2 * 32 + 16) - (double)(this.sh / 2) / this.scale);
        int n5 = (int)((double)(this.ww * 32) - (double)this.sw / this.scale);
        n3 = MathHelper.clamp(n3, 0, n5);
        int n6 = (int)((double)(this.wh * 32) - (double)this.sh / this.scale);
        n4 = MathHelper.clamp(n4, 0, n6);
        this.dvx = n3 - this.svx;
        this.dvy = n4 - this.svy;
    }

    @Override
    public void center() {
        this.svx += this.dvx;
        this.svy += this.dvy;
        this.dvx = 0;
        this.dvy = 0;
        this.speed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (StendhalClient.get().tryAcquireDrawingSemaphore()) {
            try {
                super.paintImmediately(n, n2, n3, n4);
            }
            finally {
                StendhalClient.get().releaseDrawingSemaphore();
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (StendhalClient.get().isInTransfer()) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (graphics2D2.getClipBounds() == null) {
            graphics2D2.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        int n = -this.getScreenViewX();
        int n2 = -this.getScreenViewY();
        if (this.useTripleBuffer) {
            graphics2D2.scale(this.scale, this.scale);
            graphics2D2.translate(n, n2);
            graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            int n3 = stendhal.getDisplaySize().width;
            int n4 = stendhal.getDisplaySize().height;
            do {
                GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
                if (this.buffer == null || this.buffer.validate(graphicsConfiguration) == 2) {
                    this.buffer = this.createVolatileImage(n3, n4);
                }
                Graphics2D graphics2D3 = this.buffer.createGraphics();
                graphics2D3.setClip(0, 0, n3, n4);
                this.renderScene(graphics2D3, n, n2);
                graphics2D2.drawImage(this.buffer, -n, -n2, null);
                graphics2D3.dispose();
            } while (this.buffer.contentsLost());
        } else {
            this.renderScene(graphics2D2, n, n2);
        }
        this.drawText(graphics2D);
        this.paintOffLineIfNeeded(graphics2D);
        graphics2D2.dispose();
    }

    private void renderScene(Graphics2D graphics2D, int n, int n2) {
        graphics2D.translate(n, n2);
        int n3 = Math.max(0, (int)this.getViewX());
        int n4 = Math.max(0, (int)this.getViewY());
        Rectangle rectangle = graphics2D.getClipBounds();
        n3 = Math.max(n3, rectangle.x / 32);
        n4 = Math.max(n4, rectangle.y / 32);
        int n5 = this.getViewWidth();
        int n6 = this.getViewHeight();
        n5 = Math.min(n5, rectangle.width / 32) + 2;
        n6 = Math.min(n6, rectangle.height / 32) + 2;
        this.drawEndOfTheWorld(graphics2D, n, n2);
        this.viewManager.prepareViews(rectangle);
        String string = this.gameLayers.getAreaName();
        this.gameLayers.drawLayers(graphics2D, string, "floor_bundle", n3, n4, n5, n6, "blend_ground", "0_floor", "1_terrain", "2_object");
        this.viewManager.draw(graphics2D);
        this.gameLayers.drawLayers(graphics2D, string, "roof_bundle", n3, n4, n5, n6, "blend_roof", "3_roof", "4_roof_add");
        this.gameLayers.drawWeather(graphics2D, n3, n4, n5, n6);
        this.viewManager.drawTop(graphics2D);
        Iterator<EffectLayer> iterator = globalEffects.iterator();
        while (iterator.hasNext()) {
            EffectLayer effectLayer = iterator.next();
            if (!effectLayer.isExpired()) {
                effectLayer.draw(graphics2D, n3, n4, n5, n6);
                continue;
            }
            iterator.remove();
        }
    }

    private void drawEndOfTheWorld(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        if (n > 0) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, n, this.sh);
        }
        if (n2 > 0) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.sw, n2);
        }
        if ((n4 = n2 + this.convertWorldToPixelUnits(this.wh)) < this.sh) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(this.svx, n4, this.sw, this.sh);
        }
        if ((n3 = n2 + this.convertWorldToPixelUnits(this.ww)) < this.sw) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n3, this.svy, this.sw, this.sh);
        }
    }

    private void paintOffLineIfNeeded(Graphics graphics) {
        if (this.offline) {
            if (this.blinkOffline > 0) {
                offlineIcon.draw(graphics, this.getWidth() - offlineIcon.getWidth() - 10, this.getHeight() - offlineIcon.getHeight() - 10);
            }
            this.blinkOffline = this.blinkOffline < -10 ? 20 : --this.blinkOffline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawText(Graphics2D graphics2D) {
        RemovableSprite removableSprite;
        Iterator<RemovableSprite> iterator;
        graphics2D.translate(-this.getScreenViewX(), -this.getScreenViewY());
        List<RemovableSprite> list = this.texts;
        synchronized (list) {
            iterator = this.texts.iterator();
            while (iterator.hasNext()) {
                removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.draw(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
        graphics2D.translate(this.getScreenViewX(), this.getScreenViewY());
        list = this.staticSprites;
        synchronized (list) {
            iterator = this.staticSprites.iterator();
            while (iterator.hasNext()) {
                removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.draw(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private double getViewX() {
        return (double)this.getScreenViewX() / 32.0;
    }

    private double getViewY() {
        return (double)this.getScreenViewY() / 32.0;
    }

    private void setMaxWorldSize(double d, double d2) {
        this.ww = (int)d;
        this.wh = (int)d2;
        this.calculateView(this.x, this.y);
        this.center();
    }

    @Override
    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextBox(Sprite sprite, double d, double d2, int n) {
        int n2 = this.convertWorldXToScaledScreen(d);
        int n3 = this.convertWorldYToScaledScreen(d2);
        n3 -= sprite.getHeight();
        n2 = this.keepSpriteOnMapX(sprite, n2);
        n3 = this.keepSpriteOnMapY(sprite, n3);
        boolean bl = true;
        int n4 = 0;
        while (bl) {
            bl = false;
            List<RemovableSprite> list = this.texts;
            synchronized (list) {
                for (RemovableSprite removableSprite : this.texts) {
                    if (removableSprite.getX() != n2 || removableSprite.getY() != n3) continue;
                    bl = true;
                    n3 += 16;
                    n3 = this.keepSpriteOnMapY(sprite, n3);
                    break;
                }
            }
            if (++n4 <= 20) continue;
        }
        this.texts.add(new RemovableSprite(sprite, n2, n3, Math.max(5000L, (long)n * 5000L / 50L)));
    }

    private int keepSpriteOnMapY(Sprite sprite, int n) {
        n = Math.max(n, 0);
        if (this.wh != 0) {
            n = Math.min(n, Math.max(this.getHeight() + this.svy, this.convertWorldYToScaledScreen(this.wh)) - sprite.getHeight());
        }
        return n;
    }

    private int keepSpriteOnMapX(Sprite sprite, int n) {
        n = Math.max(n, 0);
        if (this.ww != 0) {
            n = Math.min(n, Math.max(this.getWidth() + this.svx, this.convertWorldXToScaledScreen(this.ww)) - sprite.getWidth());
        }
        return n;
    }

    @Override
    public void removeText(RemovableSprite removableSprite) {
        this.texts.remove(removableSprite);
        this.staticSprites.remove(removableSprite);
    }

    private void removeAllObjects() {
        logger.debug((Object)"CLEANING screen object list");
        this.texts.clear();
    }

    @Override
    public void clearTexts() {
        this.texts.clear();
        this.staticSprites.clear();
    }

    @Override
    public EntityView<?> getEntityViewAt(double d, double d2) {
        int n = this.convertWorldToPixelUnits(d);
        int n2 = this.convertWorldToPixelUnits(d2);
        return this.viewManager.getEntityViewAt(d, d2, n, n2);
    }

    @Override
    public EntityView<?> getMovableEntityViewAt(double d, double d2) {
        int n = this.convertWorldToPixelUnits(d);
        int n2 = this.convertWorldToPixelUnits(d2);
        return this.viewManager.getMovableEntityViewAt(d, d2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovableSprite getTextAt(int n, int n2) {
        Object object;
        List<RemovableSprite> list = this.staticSprites;
        synchronized (list) {
            ListIterator<RemovableSprite> listIterator = this.staticSprites.listIterator(this.staticSprites.size());
            while (listIterator.hasPrevious()) {
                object = listIterator.previous();
                if (!((RemovableSprite)object).getArea().contains(n, n2)) continue;
                return object;
            }
        }
        int n3 = n + this.svx;
        int n4 = n2 + this.svy;
        object = this.texts;
        synchronized (object) {
            ListIterator<RemovableSprite> listIterator = this.texts.listIterator(this.texts.size());
            while (listIterator.hasPrevious()) {
                RemovableSprite removableSprite = listIterator.previous();
                if (!removableSprite.getArea().contains(n3, n4)) continue;
                return removableSprite;
            }
        }
        return null;
    }

    private int convertWorldXToScaledScreen(double d) {
        return (int)((double)this.convertWorldToPixelUnits(d - (double)this.svx / 32.0) * this.scale) + this.svx;
    }

    private int convertWorldYToScaledScreen(double d) {
        return (int)((double)this.convertWorldToPixelUnits(d - (double)this.svy / 32.0) * this.scale) + this.svy;
    }

    private int convertWorldToPixelUnits(double d) {
        return (int)(d * 32.0);
    }

    @Override
    public Point2D convertScreenViewToWorld(Point point) {
        return this.convertScreenViewToWorld(point.x, point.y);
    }

    @Override
    public Point2D convertScreenViewToWorld(int n, int n2) {
        return new Point2D.Double(((double)n / this.scale + (double)this.getScreenViewX()) / 32.0, ((double)n2 / this.scale + (double)this.getScreenViewY()) / 32.0);
    }

    private int getScreenViewX() {
        return this.svx;
    }

    private int getScreenViewY() {
        return this.svy;
    }

    @Override
    public void positionChanged(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        if (n != this.x || n2 != this.y) {
            this.x = n;
            this.y = n2;
            this.calculateView(n, n2);
        }
    }

    @Override
    public void dropEntity(IEntity iEntity, int n, Point point) {
        this.ground.dropEntity(iEntity, n, point);
    }

    public void addAchievementBox(String string, String string2, String string3) {
        Sprite sprite = this.getAchievementFactory().createAchievementBox(string, string2, string3);
        this.addStaticSprite(sprite, 10000L, 0);
    }

    public void addStaticText(Sprite sprite, int n, int n2) {
        this.addStaticSprite(sprite, Math.max(5000L, (long)n * 5000L / 50L), n2);
    }

    private void addStaticSprite(Sprite sprite, long l, int n) {
        int n2 = (this.getWidth() - sprite.getWidth()) / 2;
        int n3 = this.getHeight() - sprite.getHeight();
        RemovableSprite removableSprite = new RemovableSprite(sprite, n2, n3, l);
        removableSprite.setPriority(n);
        this.staticSprites.add(removableSprite);
        Collections.sort(this.staticSprites);
    }

    @Override
    public void onZoneUpdate(Zone zone) {
        this.viewManager.resetViews();
    }

    @Override
    public void onZoneChange(Zone zone) {
        this.removeAllObjects();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                globalEffects.clear();
            }
        });
    }

    @Override
    public void onZoneChangeCompleted(final Zone zone) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameScreen.this.setMaxWorldSize(zone.getWidth(), zone.getHeight());
            }
        });
    }

    public void switchToSpellCasting(KeyEvent keyEvent) {
        RPObject rPObject = this.findSpell(keyEvent);
        if (rPObject != null) {
            this.switchToSpellCastingState(rPObject);
        }
    }

    public void switchToSpellCastingState(RPObject rPObject) {
        SpellCastingGroundContainerMouseState spellCastingGroundContainerMouseState = new SpellCastingGroundContainerMouseState(this.ground);
        this.ground.setNewMouseHandlerState(spellCastingGroundContainerMouseState);
        spellCastingGroundContainerMouseState.setSpell(rPObject);
    }

    private RPObject findSpell(KeyEvent keyEvent) {
        RPObject rPObject = StendhalClient.get().getPlayer();
        Integer n = keyEventMapping.get(keyEvent.getKeyCode());
        RPSlot rPSlot = rPObject.getSlot("spells");
        Integer n2 = 1;
        for (RPObject rPObject2 : rPSlot) {
            if (n2.equals(n)) {
                return rPObject2;
            }
            n2 = n2 + 1;
        }
        return null;
    }

    @Override
    public boolean canAccept(IEntity iEntity) {
        return iEntity instanceof Item || iEntity instanceof Corpse;
    }

    static {
        keyEventMapping.put(49, 1);
        keyEventMapping.put(50, 2);
        keyEventMapping.put(51, 3);
        keyEventMapping.put(52, 4);
        keyEventMapping.put(53, 5);
        keyEventMapping.put(54, 6);
        keyEventMapping.put(55, 7);
        keyEventMapping.put(56, 8);
        keyEventMapping.put(57, 9);
        keyEventMapping.put(48, 10);
        globalEffects = new LinkedList<EffectLayer>();
        offlineIcon = SpriteStore.get().getSprite("data/gui/offline.png");
    }
}

