/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.ObjectChangeListener;
import games.stendhal.client.ObjectFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marauroa.client.net.IPerceptionListener;
import marauroa.common.game.RPObject;
import marauroa.common.net.message.MessageS2CPerception;

class PerceptionToObject
implements IPerceptionListener {
    final Map<RPObject.ID, Set<ObjectChangeListener>> map = new HashMap<RPObject.ID, Set<ObjectChangeListener>>();
    private final ObjectFactory of = new ObjectFactory();

    PerceptionToObject() {
    }

    public boolean onAdded(RPObject rPObject) {
        this.of.onAdded(rPObject, this);
        this.onModifiedAdded(rPObject, rPObject);
        return false;
    }

    public boolean onClear() {
        for (Set<ObjectChangeListener> set : this.map.values()) {
            for (ObjectChangeListener objectChangeListener : set) {
                objectChangeListener.deleted();
            }
        }
        this.map.clear();
        return false;
    }

    public boolean onDeleted(RPObject rPObject) {
        Set<ObjectChangeListener> set;
        if (rPObject != null && (set = this.map.get(rPObject.getID())) != null) {
            for (ObjectChangeListener objectChangeListener : set) {
                objectChangeListener.deleted();
                this.map.remove(rPObject.getID());
            }
        }
        return false;
    }

    public void onException(Exception exception, MessageS2CPerception messageS2CPerception) {
        this.onClear();
    }

    public boolean onModifiedAdded(RPObject rPObject, RPObject rPObject2) {
        Set<ObjectChangeListener> set;
        if (rPObject != null && (set = this.map.get(rPObject.getID())) != null) {
            for (ObjectChangeListener objectChangeListener : set) {
                objectChangeListener.modifiedAdded(rPObject2);
            }
        }
        return false;
    }

    public boolean onModifiedDeleted(RPObject rPObject, RPObject rPObject2) {
        Set<ObjectChangeListener> set;
        if (rPObject != null && (set = this.map.get(rPObject.getID())) != null) {
            for (ObjectChangeListener objectChangeListener : set) {
                objectChangeListener.modifiedDeleted(rPObject2);
            }
        }
        return false;
    }

    public boolean onMyRPObject(RPObject rPObject, RPObject rPObject2) {
        Set<ObjectChangeListener> set;
        if (rPObject2 != null && (set = this.map.get(rPObject2.getID())) != null) {
            for (ObjectChangeListener objectChangeListener : set) {
                objectChangeListener.modifiedDeleted(rPObject2);
            }
        }
        if (rPObject != null && (set = this.map.get(rPObject.getID())) != null) {
            for (ObjectChangeListener objectChangeListener : set) {
                objectChangeListener.modifiedAdded(rPObject);
            }
        }
        return false;
    }

    public void onPerceptionBegin(byte by, int n) {
    }

    public void onPerceptionEnd(byte by, int n) {
    }

    public void onSynced() {
    }

    public void onUnsynced() {
    }

    void register(RPObject rPObject, ObjectChangeListener objectChangeListener) {
        if (rPObject != null) {
            if (!this.map.containsKey(rPObject.getID())) {
                this.map.put(rPObject.getID(), new HashSet());
            }
            this.map.get(rPObject.getID()).add(objectChangeListener);
        }
    }

    void unregister(ObjectChangeListener objectChangeListener) {
        for (Set<ObjectChangeListener> set : this.map.values()) {
            set.remove(objectChangeListener);
        }
    }
}

