/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.actions;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.actions.SlashAction;
import games.stendhal.client.gui.UserInterface;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.chatlog.StandardEventLine;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.common.NotificationType;
import games.stendhal.common.math.Numeric;

class VolumeAction
implements SlashAction {
    VolumeAction() {
    }

    @Override
    public boolean execute(String[] stringArray, String string) {
        if (stringArray[0] == null) {
            float f = ClientSingletonRepository.getSound().getVolume();
            UserInterface userInterface = ClientSingletonRepository.getUserInterface();
            userInterface.addEventLine(new StandardEventLine("Please use /volume <name> <value> to adjust the volume."));
            userInterface.addEventLine(new HeaderLessEventLine("<name> is an item from the following list. \"master\" refers to the global volume setting.", NotificationType.CLIENT));
            userInterface.addEventLine(new HeaderLessEventLine("<value> is in the range from 0 to 100 but may be set higher.", NotificationType.CLIENT));
            userInterface.addEventLine(new HeaderLessEventLine("master -> " + Numeric.floatToInt(f, 100.0f), NotificationType.CLIENT));
            for (String string2 : ClientSingletonRepository.getSound().getGroupNames()) {
                f = ClientSingletonRepository.getSound().getGroup(string2).getVolume();
                userInterface.addEventLine(new HeaderLessEventLine(string2 + " -> " + Numeric.floatToInt(f, 100.0f), NotificationType.CLIENT));
            }
        } else if (stringArray[1] != null) {
            this.changeVolume(stringArray[0], stringArray[1]);
        } else {
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine("Please use /volume for help.", NotificationType.ERROR));
        }
        return true;
    }

    private void changeVolume(String string, String string2) {
        try {
            boolean bl = false;
            for (String object : ClientSingletonRepository.getSound().getGroupNames()) {
                if (!object.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n = Integer.parseInt(string2);
                SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
                soundGroup.changeVolume(Numeric.intToFloat(n, 100.0f));
                WtWindowManager.getInstance().setProperty("sound.volume." + string, Integer.toString(n));
            } else if (string.equals("master")) {
                int n = Integer.parseInt(string2);
                ClientSingletonRepository.getSound().changeVolume(Numeric.intToFloat(n, 100.0f));
                WtWindowManager.getInstance().setProperty("sound.volume." + string, Integer.toString(n));
            } else {
                ClientSingletonRepository.getUserInterface().addEventLine(new StandardEventLine("No sound group \"" + string + "\" does exist"));
                ClientSingletonRepository.getUserInterface().addEventLine(new StandardEventLine("Please type \"/volume show\" for a valid list of groups"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string2 + " is not a valid number", NotificationType.ERROR));
        }
    }

    @Override
    public int getMaximumParameters() {
        return 2;
    }

    @Override
    public int getMinimumParameters() {
        return 0;
    }
}

