/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import marauroa.common.game.Definition;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;

public enum ActionType {
    LOOK("look", "Look"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    READ("look", "Read"),
    LOOK_CLOSELY("use", "Look closely"),
    INSPECT("inspect", "Inspect"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    ATTACK("attack", "Attack"),
    STOP_ATTACK("stop", "Stop attack"),
    PUSH("push", "Push"),
    CLOSE("use", "Close"),
    OPEN("use", "Open"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    OWN("own", "Own"),
    USE("use", "Use"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    HARVEST("use", "Harvest"),
    PICK("use", "Pick"),
    PROSPECT("use", "Prospect"),
    FISH("use", "Fish"),
    WISH("use", "Make a Wish"),
    LEAVE_SHEEP("forsake", "Leave sheep"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("species", "sheep");
            return rPAction;
        }
    }
    ,
    LEAVE_PET("forsake", "Leave pet"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("species", "pet");
            return rPAction;
        }
    }
    ,
    ADD_BUDDY("addbuddy", "Add to Buddies"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    IGNORE("ignore", "Ignore"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    UNIGNORE("unignore", "Remove Ignore"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    TRADE("trade", "Trade"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("action", "offer_trade");
            return rPAction;
        }
    }
    ,
    ADMIN_INSPECT("inspect", "(*)Inspect"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    ADMIN_DESTROY("destroy", "(*)Destroy"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    ADMIN_ALTER("alter", "(*)Alter"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    SET_OUTFIT("outfit", "Set outfit"),
    WHERE("where", "Where"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    ADMIN_VIEW_NPC_TRANSITIONS("npctransitions", "(*)View Transitions"),
    KNOCK("knock", "Knock"),
    INVITE("group_management", "Invite"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("action", "invite");
            rPAction.put("params", iEntity.getName());
            return rPAction;
        }
    }
    ,
    WALK_START("walk", "Walk"),
    WALK_STOP("walk", "Stop"),
    CHALLENGE("challenge", "Challenge"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("type", "challenge");
            rPAction.put("action", "open");
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    ACCEPT_CHALLENGE("challenge", "Accept"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("type", "challenge");
            rPAction.put("action", "accept");
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    };

    private final String actionCode;
    private final String actionRepresentation;

    private ActionType(String string2, String string3) {
        this.actionCode = string2;
        this.actionRepresentation = string3;
    }

    public static ActionType getbyRep(String string) {
        for (ActionType actionType : ActionType.values()) {
            if (!actionType.actionRepresentation.equals(string)) continue;
            return actionType;
        }
        return null;
    }

    public String toString() {
        return this.actionCode;
    }

    public String getRepresentation() {
        return this.actionRepresentation;
    }

    public void send(RPAction rPAction) {
        StendhalClient.get().send(rPAction);
    }

    public RPAction fillTargetInfo(IEntity iEntity) {
        RPAction rPAction = new RPAction();
        RPClass rPClass = RPClass.getRPClass((String)this.actionCode);
        boolean bl = true;
        if (rPClass != null) {
            rPAction.setRPClass(this.actionCode);
            if (rPClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, "zone") == null) {
                bl = false;
            }
        } else {
            rPAction.put("type", this.toString());
        }
        RPObject rPObject = iEntity.getRPObject();
        int n = rPObject.getID().getObjectID();
        if (bl) {
            rPAction.put("zone", iEntity.getRPObject().getBaseContainer().get("zoneid"));
        }
        if (rPObject.isContained()) {
            rPAction.put("baseobject", rPObject.getContainer().getID().getObjectID());
            rPAction.put("baseslot", rPObject.getContainerSlot().getName());
            rPAction.put("baseitem", n);
        } else {
            StringBuilder stringBuilder = new StringBuilder("#");
            stringBuilder.append(Integer.toString(n));
            rPAction.put("target", stringBuilder.toString());
        }
        return rPAction;
    }

    RPAction fillTargetPath(RPAction rPAction, IEntity iEntity) {
        rPAction.put("target_path", iEntity.getPath());
        return rPAction;
    }

    public String getActionCode() {
        return this.actionCode;
    }
}

